
<?php $__env->startSection('css'); ?>
<link rel="stylesheet"
      href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">

<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
    .dt-buttons{
        float: right !important;
    }
    .dt-button{
        color: #000;
        background: #fff;
    }

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Consolidated Report</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <form class="form-inline">
            <div class="form-group">
                <label>Form Date </label>
                <input type="date" name="form_date" value="<?php echo e(request('form_date')); ?>" class="form-control" />
                <label>To Date </label>
                <input type="date" name="till_date" value="<?php echo e(request('till_date')); ?>" class="form-control"/>
            </div>
            <button type="submit" class="btn btn-success">Find</button>
        </form>
    </div>
</div>
<br>
<br>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="Datatable" class="table table-bordered table-striped">
                        <thead>
                            <tr class="seprator">
                                <th>Sr.No</th>
                                <?php if(request('date')): ?>
                                <th>Date</th>
                                <?php endif; ?>
                                <?php if(\Auth::user()->role == 1): ?>
                                <th>Member Id</th>
                                <th>Member Name</th>
                                <?php endif; ?>
                                <?php if($directshow == 'yes'): ?>
                                <th>Direct</th>
                                <?php endif; ?>
                                <th>ROI</th>
                                <th>Level On ROI</th>
                                <th>Total Payout</th>
                                <th>TDS</th>
                                <th>Admin Charges</th>
                                <th>Net Payment</th>
                                <th>Amount Paid</th>
                                <th>Net Balance</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i); ?></td>
                                <?php if(request('date')): ?>
                                <td><?php echo e($selected); ?></td>
                                <?php endif; ?>
                                <?php if(\Auth::user()->role == 1): ?>
                                <td><?php echo e($row->username); ?></td>
                                <td><?php echo e($row->name); ?></td>
                                <?php endif; ?>
                                <?php
                                $directQuery = \App\DirectReferral::where('user_id', $row->id)
                                        ->where('status', 1);

                                $roiQuery = \App\RoiIncome::where('user_id', $row->id)
                                        ->where('status', 1);

                                $levelRoiQuery = \App\ReferralRoi::where('user_id', $row->id)
                                        ->where('status', 1);

                                if (request('form_date')) {
                                    $directQuery->whereDate('date', '>=', request('form_date'));
                                    $roiQuery->whereDate('date', '>=', request('form_date'));
                                    $levelRoiQuery->whereDate('date', '>=', request('form_date'));
                                }

                                if (request('till_date')) {
                                    $directQuery->whereDate('date', '<=', request('till_date'));
                                    $roiQuery->whereDate('date', '<=', request('till_date'));
                                    $levelRoiQuery->whereDate('date', '<=', request('till_date'));
                                }

                                $direct = $directQuery->sum('amount');
                                $roi = $roiQuery->sum('amount');
                                $levelroi = $levelRoiQuery->sum('amount');
                                if ($directshow == 'yes') {
                                    $total = $direct + $roi + $levelroi;
                                } else {
                                    $total = $roi + $levelroi;
                                }
                                $td = $total * 5 / 100;
                                $sc = $total * 5 / 100;
                                $total_charges = $td + $sc
                                ?>
                                <?php if($directshow == 'yes'): ?>
                                <td>
                                    <?php echo e(App\WalletRequest::amountFormat($direct)); ?>

                                </td>
                                <?php endif; ?>
                                <td>
                                    <?php echo e(App\WalletRequest::amountFormat($roi)); ?>

                                </td>
                                <td>
                                    <?php echo e(App\WalletRequest::amountFormat($levelroi)); ?>

                                </td>
                                <td><?php echo e(App\WalletRequest::amountFormat($total)); ?></td>
                                <td><?php echo e(App\WalletRequest::amountFormat(round($td,2))); ?></td>
                                <td><?php echo e(App\WalletRequest::amountFormat(round($sc,2))); ?></td>
                                <td><?php echo e(App\WalletRequest::amountFormat($total-$total_charges)); ?></td>
<?php
$recive = \App\Wallet::where('user_id', $row->id)
        ->where('flag', 1)
        ->when(request('from_date'), function ($q) {
            $q->whereDate('created_at', '>=', request('from_date'));
        })
        ->when(request('till_date'), function ($q) {
            $q->whereDate('created_at', '<=', request('till_date'));
        })
        ->sum('total_amount');
?>
                                <td><?php echo e(App\WalletRequest::amountFormat($recive)); ?></td>
                                <td><?php echo e(App\WalletRequest::amountFormat(\App\Wallet::getWalletblanceDate($row->id,request('form_date'),request('till_date')))); ?></td>
                            </tr>
<?php $i++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<!-- Buttons JS -->
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<!-- Excel dependency -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script>
var tabledata = $('#Datatable').DataTable({
    dom:
            "<'row align-items-center mb-2'<'col-md-6'l><'col-md-6 text-end'B>>" +
            "<'row mb-2'<'col-md-12'f>>" +
            "<'row'<'col-md-12'tr>>" +
            "<'row mt-2'<'col-md-5'i><'col-md-7'p>>",

    buttons: [
        {
            extend: 'excelHtml5',
            text: 'Download Excel',
            className: 'btn btn-dark btn-sm'
        }
    ]
});

$(document).on('click', '.delete_btn', function () {
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        input: 'textarea',
        inputPlaceholder: "Enter Reject Reason",
        icon: 'error',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#17a2b8',
        confirmButtonText: 'Yes, Reject it!',
        inputValidator: (value) => {
            return new Promise((resolve) => {
                if (value != '') {
                    resolve()
                } else {
                    resolve('Reason Required...')
                }
            })
        }
    }).then((result) => {
        if (result.value) {
            $.ajax({
                url: "<?php echo e(URL::asset('wallet/rejecteentry')); ?>",
                data: {'row_id': $(this).attr('id'), 'reason': result.value},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        }
    });
});

$(document).on('click', '.approved_btn', function () {
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        input: 'textarea',
        inputPlaceholder: "Enter Text",
        icon: 'success',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#17a2b8',
        confirmButtonText: 'Yes, Approve it!',
    }).then((result) => {
        $.ajax({
            url: "<?php echo e(URL::asset('wallet/approveentry')); ?>",
            data: {'row_id': $(this).attr('id'), 'reason': result.value},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {
                window.location.reload();
            },
            cache: false,
        });
    });
});

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/admin/consolidated.blade.php ENDPATH**/ ?>