
<?php $__env->startSection('css'); ?>
<link rel="stylesheet"
      href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">

<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
    .dt-buttons{
        float: right !important;
    }
    .dt-button{
        color: #000;
        background: #fff;
    }

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">User All Income Till Date Report</h1>
</div>
<div class="row d-none">
    <div class="col-md-12">
        <form class="form-inline">
            <div class="form-group">
                <label>Form Date </label>
                <input type="date" name="form_date" value="<?php echo e(request('form_date')); ?>" class="form-control" />
                <label>To Date </label>
                <input type="date" name="till_date" value="<?php echo e(request('till_date')); ?>" class="form-control"/>
            </div>
            <button type="submit" class="btn btn-success">Find</button>
        </form>
    </div>
</div>
<br>
<br>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <a href="<?php echo e(asset('reports/alluserincomedataexport')); ?>" class="btn btn-primary float-right"><i class="fa fa-file-excel-o"></i>Export</a>
                <br>
                <br>
                <div class="table-responsive">
                    <table id="Datatable" class="table table-bordered table-striped">
                        <thead>
                            <tr class="seprator">
                                <th>Member Id</th>
                                <th>Member Name</th>
                                <th>Phone Number</th>
                                <th>Joining Date</th>
                                <th>Activation Date</th>
                                <th>Status</th>
                                <th>Amount Invested</th>
                                <th>Direct</th>
                                <th>ROI</th>
                                <th>Level On ROI</th>
                                <th>Total Income</th>
                                <th>Total Deductions</th>
                                <th>Net Amount</th>
                                <th>Amount Paid</th>
                                <th>Balance To Be Paid</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<!-- Buttons JS -->
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<!-- Excel dependency -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script>
$('#Datatable').DataTable({
    processing: true,
    serverSide: true,
    ajax: {
        url: "<?php echo e(url('reports/alluserincomedata')); ?>",
        data: function (d) {
            d.from_date = $('#from_date').val();
            d.till_date = $('#till_date').val();
        }
    },
    columns: [
        { data: 'username' },
        { data: 'name'},
        { data: 'mobile'},
        { data: 'created_at'},
        { data: 'activation_date'},
        { data: 'active'},
        { data: 'invested'},
        { data: 'direct'},
        { data: 'roi' },
        { data: 'levelroi' },
        { data: 'total' },
        { data: 'deductions'},
        { data: 'net' },
        { data: 'paid' },
        { data: 'balance' }
    ]
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/admin/alluserincome.blade.php ENDPATH**/ ?>