<?php

use Illuminate\Support\Facades\Route;

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register web routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | contains the "web" middleware group. Now create something great!
  |
 */

//Auth::routes(['verify' => true]);
Auth::routes(['verify' => false]);

Route::get('/', function () {
    if (\Auth::user()) {
        return \Redirect::to('home');
    }
    $data['countries'] = App\Countrie::groupBy('name')->get();
    $data['banks'] = \App\Bank::orderBy('name')->get();
    return view('auth.login', $data);
});
Route::post('getstates', function () {
    $states = App\Countrie::where('name', request('country_id'))->get();
    return response()->json($states);
});


Route::post('packagedetails', 'HomeController@packagedetails')->name('packagedetails');



//Route::group(['middleware' => 'verified'], function() {
Route::get('/home', 'HomeController@index')->name('home');
AdvancedRoute::controller('frontdata', 'HomeController');

AdvancedRoute::controller('usermanage', 'UserManageController');
AdvancedRoute::controller('kyc', 'KycController');
AdvancedRoute::controller('subadmin', 'SubAdminManageController');
AdvancedRoute::controller('packages', 'ProductController');
AdvancedRoute::controller('topuppackages', 'TopUpController');
AdvancedRoute::controller('reports', 'ReportsController');
AdvancedRoute::controller('mydocs', 'ReportsController');
AdvancedRoute::controller('wallet', 'WalletController');
AdvancedRoute::controller('support', 'SupportController');
AdvancedRoute::controller('page', 'SupportController');
AdvancedRoute::controller('pagemanage', 'PagesManageController');
//});
