@extends('layouts.user')

@section('content')
<style>
    .th{
        background: #e2e3f1;
    }
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
</style>
<div class="row">
    <div class="col-md-12">
        <h3>Withdrawal Report</h3>
    </div>
</div>
<div class="row mt-3">
    <div class="col-md-12">
        <div class="table-responsive">
            <table class="table" id="data_table_withdrawal" style="width:100%">
                <thead>
                    <tr class="seprator">
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Bank</th>
                        <th>Reason</th>
                        <th>Status</th>
                        <th>Approve Date/Time</th>
                        <th>Transaction Id</th>
                        <th>Payment Proof</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {
        var oTablecash = $('#data_table_withdrawal').dataTable({
            bProcessing: true,
            bServerSide: true,
            bSort: true,
            ajax: "{{ URL::asset('wallet/withdrawal?user_id='.$user_id)}}",
            columns: [
                {data: 'created_at', name: 'created_at', orderable: false},
                {data: 'amount', name: 'amount', orderable: false},
                {data: 'bank_id', name: 'bank_id', orderable: false},
                {data: 'reason', name: 'reason', orderable: false},
                {data: 'status', name: 'status', orderable: false},
                {data: 'date_time', name: 'date_time', orderable: false},
                {data: 'transaction_id', name: 'transaction_id', orderable: false},
                {data: 'payment_proof', name: 'payment_proof', orderable: false},
            ],
        });
        $(function () {
            $('#WalletAddressform').validate({
                rules: {
                    amount: {
                        digits: true,
                        required: true,
//                        lessThan: "#amount_main"
                    }
                },
                messages: {
                    amount: "Enter Only Number Without Sign and Symbol..",
                },
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
        $(document).on('blur', '#amount_count', function () {
            $.ajax({
                url: "{{ URL::asset('wallet/checkcashrequest') }}",
                data: {'value': $(this).val()},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    $(document).find('#amount_count_2').val(data.amount);
                },
                cache: false,
            });
        });
    });
</script>
@stop
