@extends('layouts.user')
@section('css')

@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-white-800">My Top-Up History</h1>
</div>
<div class="card shadow">
    <div class="card-header py-3">
        <p class="text-primary m-0 fw-bold">List</p>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="Datatable">
                <thead>
                    <tr class="seprator">
                        <th>Sr No </th>
                        <th>Request Date </th>
                        <th>Package Name</th>
                        <th>Price</th>
                        <th>Transaction Id</th>
                        <th>Payment Proof</th>
                        <th>Status</th>
                        <th>Reason</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    @foreach($packages as $package)
                    <tr>
                        <td> {{$i}} </td>
                        <td> {{date('d-m-Y H:i',strtotime($package->created_at))}}</td>
                        <td>{{$package->package_name}}</td>
                        <td>${{$package->amount}}</td>
                        <td>
                            {{$package->transaction_id}}
                        </td>
                        <td title="View Document" class="pointer">
                            <a href="{{asset('payment_proof/'.$package->payment_proof)}}" target="_blank"><i class="fa fa-eye" aria-hidden="true" ></i></a>
                        </td>
                        <td> 
                            @if($package->status == 0)
                            <span class="text-warning">Pending</span>
                            @elseif($package->status == 1)
                            <span class="text-success">Success</span>
                            @else
                            <span class="text-danger">Rejected</span>
                            @endif
                        </td>
                        <td>{{$package->reason}}</td>
                        <td>
                            @if($package->status != 1)
                            <a class="btn btn-danger" href="{{asset('topuppackages/removetopuprequest/'.$package->id)}}">Delete</a>
                            @endif
                        </td>
                    </tr>
                    <?php $i++; ?>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>                                                                                             
@endsection

@section('script')
<script>
    $('#Datatable').DataTable();

    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
@endsection
