@extends('layouts.user')

@section('css')
<link rel="stylesheet" href="{{asset('assets/plugins/summernote/summernote-bs4.min.css')}}">
@endsection
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">View Support Message</h1>
</div>
<div class="row">
    <div class="col-lg-12 col-12">
        @if(\Auth::user()->id != 1)
        <a class="float-right" href="{{asset('support/message')}}">Back to List</a>
        @else
        <a class="float-right" href="{{asset('support/requestlist')}}">Back to List</a>
        @endif
        <strong>Query</strong> : {{$support->query}}
        <br>
        <br>
        <strong>Message</strong> : {!!$support->msg!!}
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-6">
        <div class="timeline">
            @foreach($support_comments as $comment)
            @if($comment->user_id != 1)
            <div>
                <i class="fas fa-user bg-green"></i>
                <div class="timeline-item">
                    <span class="time"><i class="fas fa-clock"></i> {{date('d-m-Y H:i',strtotime($comment->created_at))}}</span>
                    <h3 class="timeline-header"><a href="#">{{$comment->getUser?$comment->getUser->username:''}} - {{$comment->getUser?$comment->getUser->name:''}}</a></h3>
                    <div class="timeline-body">
                        {{$comment->comment}}
                    </div>
                </div>
            </div>
            @else
            <div>
                <i class="fas fa-envelope bg-blue"></i>
                <div class="timeline-item">
                    <span class="time"><i class="fas fa-clock"></i> {{date('d-m-Y H:i',strtotime($comment->created_at))}}</span>
                    <h3 class="timeline-header"><a href="#">Support Team</a></h3>
                    <div class="timeline-body">
                        {{$comment->comment}}
                    </div>
                </div>
            </div>
            @endif
            @endforeach
            <div>
                <i class="fas fa-clock bg-gray"></i>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <h4>Write Comment</h4>
        <form action="{{asset('support/sendcomment')}}" id="quickForm" method="post">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <input type="hidden" name="support_id" value="{{ $support->id }}" />
            <div class="form-group">
                <label>Enter Comment</label>
                <textarea class="form-control" rows="8" name="msg" required></textarea>
            </div>
            <button type="submit" class="btn btn-success pull-right">Send</button>
        </form>
    </div>

</div>
@endsection
@section('script')
<script>
    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
@endsection

