@extends('layouts.user')
@section('css')
<!-- Theme style -->
<!--<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/style.css') }}">
<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/const.css') }}">
<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/poppin.css') }}">-->
<style>


</style>
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Level on ROI Report</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="ctable">
                        <thead>
                            <tr>
                                <th><strong>Member Name</strong></th>
                                <th><strong>Member Id</strong></th>
                                <th><strong>ROI</strong></th>
                                <th><strong>Details</strong></th>
                            </tr>
                        </thead> 
                        <tbody>
                            <?php $j = 1; ?>
                            @foreach($users as $user)
                            @if($user)
                            <tr>
                                <td>{{$user->name}} {{$user->last_name}}</td>
                                <td>{{$user->username}}</td>
                                <td>
                                    <?php
                                    $total = \App\ReferralRoi::where('user_id', $user->id)
                                                    ->where('status', 1)->sum('amount');
                                    ?>
                                    {{App\WalletRequest::amountFormat($total)}}
                                </td>
                                <td><a href="{{asset('reports/referralincome/'.$user->id)}}">View Details</a></td>
                            </tr>
                            <?php $j++; ?>
                            @endif
                            @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div style="clear:both;"></div>
<!-- /.content -->    
@endsection


@section('script')
<script>
    $("#ctable").DataTable({
        order: [[1, 'asc']]
    });
</script>
@stop
