@extends('layouts.user')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-7">
        <div class="text-center">
            <h4 class="fw-bolder text-dark mb-4"><b>{{$packages->package_name}}</b></h4>
        </div>
        <form method="POST" enctype="multipart/form-data" action="{{ asset('topuppackages/purchasesave/'.$packages->id) }}" class="user" id="purchaseform">
            @csrf
            <div class="mb-3">
                <label class="form-label"><strong>Selected Package</strong></label>
                <input class="form-control form-control-user" type="text"  value="{{$packages->package_name}}" name="Name" readonly>
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Enter Transaction ID</strong></label>
                <input class="form-control form-control-user" type="text" placeholder="Transaction ID" name="transaction_id" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Upload Transaction Proof</strong></label>
                <input class="form-control form-control-user" type="file" placeholder="Transaction ID" name="payment_proof" accept="image/*" required>
            </div>
            <button class="btn btn-primary d-block btn-user w-100" type="submit" style="border-radius: 8px;background: #4f7bf9;font-size: 16px;font-weight: bold;">Submit</button>
            <hr>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {

        $(function () {
            $('#purchaseform_ss').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
    });
</script>
@endsection

