@extends('layouts.user')
@section('css')

@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-white-800">My Invoice History</h1>
</div>
<div class="card shadow">
    <div class="card-header py-3">
        <p class="text-primary m-0 fw-bold">List</p>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="Datatable">
                <thead>
                    <tr class="seprator">
                        <th>Sr No </th>
                        <th>Request Date </th>
                        <th>Approve Date </th>
                        <th>Package Name</th>
                        <th>Price</th>
                        <th>Invoice No.</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    @foreach($packages as $package)
                    <tr>
                        <td> {{$i}} </td>
                        <td> {{date('d-m-Y H:i',strtotime($package->created_at))}}</td>
                        <td> {{date('d-m-Y H:i',strtotime($package->approve_date))}}</td>
                        <td>{{$package->package_name}}</td>
                        <td>Rs.{{$package->amount}}</td>
                        <td>AMG00I{{$package->id}}</td>
                        <td>
                            <a class="btn btn-danger" href="{{asset('topuppackages/downloadinvice/'.$package->id)}}"><i class="fa fa-file-pdf"></i></a>
                        </td>
                    </tr>
                    <?php $i++; ?>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>                                                                                             
@endsection

@section('script')
<script>
    $('#Datatable').DataTable();

    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
@endsection
