@extends('layouts.user')

@section('content')
<style>
    .btn-warning {
        margin: 5px;
    }
</style>
<div class="d-flex justify-content-between align-items-center flex-wrap">
    <h2 class="mb-2 mb-md-0">Dashboard</h2>

    <div class="d-flex flex-wrap align-items-center gap-2">
        <span class="me-2">Share the referral link to build your team -</span>

        <button class="btn btn-warning" type="button" onclick="copyToClipboard('copy_1')">
            Copy Link <i class="fas fa-copy"></i>
        </button>

        <a class="btn btn-warning d-flex align-items-center justify-content-center"style="padding: .2rem .75rem;"
           href="https://web.whatsapp.com/send?text={{ asset('register?reffer='.\Auth::user()->username) }}"
           data-action="share/whatsapp/share">
            <i style="font-size: 30px; color: green;" class="fab fa-whatsapp-square"></i>
        </a>
    </div>

    <input type="text" id="copy_1" value="{{ asset('register?reffer='.\Auth::user()->username) }}" style="display:none;">
</div>
@if(\Auth::user()->block == 1)
<div class="alert">
    <div class="alert alert-danger">
        Congratulations. You have successfully earned 1.5 times your income! Please upgrade your ID immediately. If not upgraded, it will affect your earnings. Thank you. <a href="{{asset('topuppackages/memberactivation')}}">Upgrade</a>
    </div>
</div>
@endif
<div class="row mt-4">
    <div class="col-md-3 mb-3">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('topuppackages/mypackages')}}">My Investment</a></h6>
                <p class="card-text fs-4">RS.{{App\WalletRequest::amountFormat($my_currentinvestment)}}</p>
                <p class="card-text fs-4">${{round($my_currentinvestment/90)}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title">Team Investment</h6>
                <p class="card-text fs-4">RS.{{App\WalletRequest::amountFormat($Team_Business)}}</p>
                <p class="card-text fs-4">${{round($Team_Business/90)}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/mydirects')}}">My Directs</a></h6>
                <p class="card-text fs-4">{{$direct_team}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('wallet/withdrawalreport')}}">Payout Received</a></h6>
                <?php $recive = App\Wallet::where('user_id', \Auth::user()->id)->where('flag', 1)->sum('total_amount'); ?>
                <p class="card-text fs-4">Rs.{{$recive}}</p>
                <p class="card-text fs-4">${{round($recive/90)}}</p>
            </div>
        </div>
    </div>
</div>
<h2>My ROI</h2>
<div class="row mt-4">
    <div class="col-md-4 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/roiincome')}}">Daily ROI</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($today_roi_income)}}</p>
                <p class="card-text fs-4">${{round($today_roi_income/90)}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/roiincome')}}">Total ROI</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($roi_income)}}</p>
                <p class="card-text fs-4">${{round($roi_income/90)}}</p>
            </div>
        </div>
    </div>
</div>
<h2>My Incentives</h2>
<div class="row mt-4">
    <div class="col-md-3 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/directincome')}}">Direct Referral</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($direct_income)}}</p>
                <p class="card-text fs-4">${{round($direct_income/90)}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/referralincome/'.\Auth::user()->id)}}">Daily Level On ROI</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($today_refer_roi)}}</p>
                <p class="card-text fs-4">${{round($today_refer_roi/90)}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/referralincome/'.\Auth::user()->id)}}">Cumulative Level of ROI</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($refer_roi)}}</p>
                <p class="card-text fs-4">${{round($refer_roi/90)}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('wallet/allwalletreport')}}">Total Incentive</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat(\App\Wallet::getWalletblance(\Auth::user()->id))}}</p>
                <p class="card-text fs-4">${{round(\App\Wallet::getWalletblance(\Auth::user()->id)/90)}}</p>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    function copyToClipboard(element) {
        var copyText = document.getElementById(element);
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        navigator.clipboard.writeText(copyText.value);
    }
    // Pie Chart Example
    $(document).on('click', '.changeradiooption', function () {
        $.ajax({
            url: "{{ URL::asset('usermanage/changeposition') }}",
            data: {'set_position': $(this).val()},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {
                window.location.reload();
            },
            cache: false,
        });
    });
</script>
@endsection