@extends('layouts.user')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-7">
        <div class="d-none">$roi_income_days == 0 || $roi_income_days >= 125</div>
        @if($roi_income_days == 0 || $roi_income_days >= 125)
        <h3><b>Create Fund Request</b></h3>
        <form method="POST" enctype="multipart/form-data" action="{{ asset('topuppackages/fundrequest') }}" class="user" id="purchaseform">
            @csrf
            <div class="mb-3">
                <label class="form-label"><strong>Fund Amount</strong></label>
                <input class="form-control form-control-user" type="number" placeholder="Fund Amount" name="amount" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Transaction reference ID</strong></label>
                <input class="form-control form-control-user" type="text" placeholder="Transaction reference ID" name="transaction_id" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Transaction Mode</strong></label>
                <select class="form-control" name="mode" required>
                    <option value="case">Case</option>
                    <option value="bank">Bank Transfer</option>
                    <option value="upi">UPI</option>
                    <option value="fund">Fund Wallet {{App\WalletRequest::amountFormat(App\FundWallet::getWalletblance(\Auth::user()->id))}}</option>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Transaction Password.</strong></label>
                <input class="form-control form-control-user" type="text" placeholder="Transaction Password" name="transaction_password" required>
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Upload Transaction Proof</strong></label>
                <input class="form-control form-control-user" type="file" placeholder="Transaction ID" name="payment_proof" accept="image/*">
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Note.</strong></label>
                <textarea class="form-control" name="note" rows="5"></textarea>
            </div>
            <button class="btn btn-primary d-block btn-user w-100" type="submit" style="border-radius: 8px;background: #4f7bf9;font-size: 16px;font-weight: bold;">Send Request</button>
            <hr>
        </form>
        @else
        <div style="font-size:20px;color:orangered;">Already your investment is running you cannot top-up</div>
        @endif
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {

        $(function () {
            $('#purchaseform_ss').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
    });
</script>
@endsection

