@extends('layouts.user')
@section('css')

<link rel="stylesheet"
      href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">

<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
    .dt-buttons{
        float: right !important;
    }
    .dt-button{
        color: #000;
        background: #fff;
    }

</style>
<!-- Theme style -->
<!--<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/style.css') }}">
<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/const.css') }}">
<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/poppin.css') }}">-->
<style>


</style>
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    @if(\Auth::user()->role == 1)
    <h1 class="h3 mb-0 text-gray-800">Direct Referral Reports</h1>
    @else
    <h1 class="h3 mb-0 text-gray-800">Direct Referral Income</h1>
    @endif
</div>
<div class="row">
    <div class="col-md-12">
        @if(\Auth::user()->role == 1)
        <div class="row">
            <div class="col-md-12">
                <form class="form-inline">
                    <div class="form-group">
                        <label>Form Date </label>
                        <input type="date" name="from_date" value="{{request('from_date')}}" class="form-control" />
                        <label>To Date </label>
                        <input type="date" name="till_date" value="{{request('till_date')}}" class="form-control"/>
                    </div>
                    <button type="submit" class="btn btn-success">Find</button>
                </form>
            </div>
        </div>
        <br>
        <br>
        <div class="table-responsive">
            <table id="Datatableadmin" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th><strong>Member ID</strong></th>
                        <th><strong>Member Name</strong></th>
                        <th><strong>Date</strong></th>
                        <th><strong>Reffer Member ID</strong></th>
                        <th><strong>Reffer Member Name</strong></th>
                        <th><strong>Invest Amount</strong></th>
                        <th><strong>Amount</strong></th>
                        <th><strong>TDS/Admin Charges</strong></th>
                        <th><strong>Net Amount</strong></th>
                    </tr>
                </thead> 
                <tbody>
                    <?php $j = 1; ?>
                    @foreach($userdetils as $user)
                    @if($user->getreferralid)
                    <tr>
                        <td>{{$user->getuser->username}}</td>
                        <td>{{$user->getuser->name}} {{$user->getuser->last_name}}</td>
                        <td>{{date('d-m-Y',strtotime($user->date))}}</td>
                        <td>{{$user->getreferralid->username}}</td>
                        <td>{{$user->getreferralid->name}} {{$user->getreferralid->last_name}}</td>
                        <td>
                            <?php
                            $amount = \App\WalletRequest::where('status', 1)
                                            ->where('user_id', $user->getreferralid->id)->where('approve_date', '<=', $user->created_at)->first();
                            ?>
                            {{$amount?$amount->amount:'0'}}
                        </td>
                        <td>{{$user->amount}}</td>
                        <td>{{$user->charges}}</td>
                        <td>{{$user->net_amount}}</td>
                    </tr>
                    @endif
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="table-responsive">
            <table id="Datatable" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th><strong>S.No </strong></th>
                        <th><strong>{{\Auth::user()->role == 1?'MemberID':'Referral Name'}}</strong></th>
                        <th><strong>Status</strong></th>
                        <th><strong>Amount</strong></th>
                        <th><strong>TDS/Admin Charges %</strong></th>
                        <th><strong>Net Amount</strong></th>
                        @if(\Auth::user()->role == 2)
                        <th><strong>Wallet</strong></th>
                        @endif
                    </tr>
                </thead> 
                <tbody>
                    <?php $j = 1; ?>
                    @foreach($userdetils as $user)
                    @if($user->getreferralid)
                    <tr>
                        <td>{{$j}}</td>
                        <td>{{$user->getreferralid->name}} {{$user->getreferralid->last_name}}</td>
                        <td>
                            {{$user->getreferralid->active ==0?'Inactive':'Active'}}
                        </td>
                        <td>{{$user->amount}}</td>
                        <td>{{$user->charges}}</td>
                        <td>{{$user->net_amount}}</td>
                        @if(\Auth::user()->role == 2)
                        <td>{{$user->status ==1?'Added':'Not Added'}}</td>
                        @endif
                    </tr>
                    <?php $j++; ?>
                    @endif
                    @endforeach
                </tbody>
            </table>
        </div>
        @endif
    </div>
</div>
<div style="clear:both;"></div>
<!-- /.content -->    
@endsection


@section('script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script>
$('#Datatableadmin').DataTable({
    order: [[2, 'desc']],
    dom:
            "<'row align-items-center mb-2'<'col-md-6'l><'col-md-6 text-end'B>>" +
            "<'row mb-2'<'col-md-12'f>>" +
            "<'row'<'col-md-12'tr>>" +
            "<'row mt-2'<'col-md-5'i><'col-md-7'p>>",

    buttons: [
        {
            extend: 'excelHtml5',
            text: 'Download Excel',
            className: 'btn btn-dark btn-sm'
        }
    ]
});
$("#Datatable").DataTable();
</script>
@stop
