<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
        <title>MalaysianTrade - Register</title>
        <link rel="shortcut icon" href="{{asset('images/logo.png')}}" />
        <link rel="stylesheet" href="{{asset('css/sb-admin-2.min.css')}}">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i&amp;display=swap">
        <link
            rel="stylesheet"
            href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css"
            />
        <style>
            .form-control-user{
                border-radius: 8px !important;
            }
            .error {
                color:red;
                font-size:15px;
                width:100%;
            }
            body {
                background-color: #000 !important;
                color:#fff;
                font-size: 1.2rem;
            }
            h4{
                color:#ffcc00 !important;
            }
            .iti{
                width:100%;
            }
            .iti__country-list{
                color:#000;
            }
        </style>
    </head>
    <body class="bg-gradient-primary" style="background: var(--bs-gray-100);">
        <div class="container">
            <div class="card shadow-lg o-hidden border-0 my-5" style="color:#fff;background-color: #000;box-shadow: 0px 0rem 1rem #fff !important;">
                <div class="card-body p-0">
                    <div class="row justify-content-center">
                        <div class="col-lg-7">
                            <div class="p-5" style="border-radius: 36px;">
                                <div class="text-center"><img src="{{asset('images/logo.png')}}" style="height:120px;">
                                    <h4 class="fw-bolder mb-4">Sign Up</h4>
                                    <p>Hello! Start Earning after a simple signup.<br></p>
                                </div>
                                @if(\Session::get('success'))
                                <div class="alert alert-success alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                    <h5><i class="icon fas fa-check"></i> Success!</h5>
                                    {{\Session::get('success')}}
                                </div>
                                @endif
                                @if(\Session::get('error'))
                                <div class="alert alert-danger alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                    <h5><i class="icon fas fa-exclamation-triangle"></i> Error!</h5>
                                    {{\Session::get('error')}}
                                </div>
                                @endif
                                @if($errors->any())
                                <div class="alert alert-danger">
                                    <p><strong>Opps Something went wrong</strong></p>
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                                @endif
                                <form method="POST" action="{{ route('register') }}" class="user" id="registerform">
                                    @csrf
                                    <input type="text" style="display:none">
                                    <input type="password" style="display:none">
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col">
                                                <div class="">
                                                    <label class="form-label" for="name">Full Name *</label>
                                                    <input class="form-control form-control-user" type="text" placeholder="Full Name" name="name" required />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group" style="display:none;">
                                        <div class="mb-3">
                                            <label class="form-label">Username</label>
                                            <input class="form-control form-control-user" type="text"   placeholder="Username" name="username" autocomplete="off" required />
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Email Id</label>
                                        <input class="form-control form-control-user" type="email"   placeholder="Email Address" name="email" />
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Mobile No. *</label>
                                        <br>
                                        <input type="hidden" name="country_code" id="country_code">
                                        <input type="hidden" name="mobile_code" id="full_phone">
                                        <input id="phone" class="form-control"  type="number"   placeholder="Mobile Number" name="mobile" required />
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Country</label>
                                        <input class="form-control form-control-user" type="text"   placeholder="Country" name="country" />
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">State</label>
                                        <input class="form-control form-control-user" type="text"   placeholder="State" name="state" />
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Referred By *</label>
                                        @if(request('sponser'))
                                        <input id="sponsor_change" class="form-control form-control-user" type="text" value="{{request('sponser')}}" readonly placeholder="Sponser ID" name="sponser" required />
                                        <input class="form-control form-control-user" type="hidden" value="{{request('position')}}"  placeholder="Referral" name="position" required />
                                        @else
                                        <input id="sponsor_change" class="form-control form-control-user" type="text" value="{{request('reffer')}}"  placeholder="Referral" name="sponser" required />
                                        @endif
                                        <div id="sponsor_response"></div>
                                    </div>
                                    <div class="mb-3">
                                        <input  type="checkbox" class="" name="term" required> 
                                        <button type="button" class="btn btn-link" data-toggle="modal" data-target="#exampleModal">
                                            I agree to the Term & Condition
                                        </button>
                                        <!-- Modal -->
                                        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Our Term & Condition</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body" style="font-size:13px;">
                                                        <?php
                                                        $term = App\CommonSetting::where('field_name', 'termcondition')->first()
                                                        ?>
                                                        {!!$term?$term->field_value:''!!}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-primary d-block btn-user w-100" type="submit" style="border-radius: 8px;background:#F4CF31;color:#000;font-weight: bold;font-size: 17px;">Register Account</button>
                                    <hr>
                                </form>
                                <div class="text-center"><a class="small" href="#">Forgot Password?</a></div>
                                <div class="text-center"><a class="small" href="{{ asset('login') }}">Already have an account? Login!</a></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Bootstrap core JavaScript-->
        <script src="{{asset('plugins/jquery/jquery.min.js')}}"></script>
        <script src="{{asset('plugins/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
        <!-- Core plugin JavaScript-->
        <script src="{{asset('plugins/jquery-easing/jquery.easing.min.js')}}"></script>
        <!-- Custom scripts for all pages-->
        <script src="{{asset('js/sb-admin-2.min.js')}}"></script>
        <script src="{{asset('plugins/bootstrap/js/bootstrap.min.js')}}"></script>
        <script src="{{asset('plugins/jquery-validation/jquery.validate.min.js')}}"></script>
        <script src="{{asset('plugins/jquery-validation/additional-methods.min.js')}}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
        <script>
const phoneInputField = document.querySelector("#phone");
const fullPhoneInput = document.querySelector("#full_phone");
const country_code = document.querySelector("#country_code");

const iti = window.intlTelInput(phoneInputField, {
    initialCountry: "auto",
    geoIpLookup: function (callback) {
        fetch('https://ipapi.co/json')
                .then(res => res.json())
                .then(data => callback(data.country_code))
                .catch(() => callback("in"));
    },
    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js"
});

// Before form submit, update the hidden input with full number
$(document).on('blur', '#phone', function () {
    const fullNumber = iti.getNumber(); // e.g. +1234567890
    fullPhoneInput.value = fullNumber;
    country_code.value = iti.getSelectedCountryData().dialCode;
});
        </script>


    </script>
    <script>
        $(document).ready(function () {


            $(document).on('blur', '#sponsor_change', function () {
                if ($(this).val() != '')
                {
                    var sponsor = $("#sponsor_change").val().trim();
                    var _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "{{ asset('frontdata/fetchsponsor') }}",
                        method: "POST",
                        data: {sponsor: sponsor, _token: _token},
                        success: function (response)
                        {
                            if (response) {
                                $("#sponsor_response").html(response);
                            } else {
                                $("#sponsor_response").html('Invalid Sponsor ID');
                            }
                        }
                    })
                }
            });
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $(function () {
                $('#registerform').validate({
                    rules: {
                        username: {
                            required: true,
                            alphanumeric: true
                        },
                        mobile: {
                            minlength: 10,
                            maxlength: 10

                        },
                        password: {
                            minlength: 6
                        },
                        password_confirm: {
                            minlength: 6,
                            equalTo: "#samepassword"
                        }
                    },
                    errorElement: 'span',
                    errorPlacement: function (error, element) {
                        error.addClass('invalid-feedback');
                        error.insertAfter(element);
                    },
                    highlight: function (element, errorClass, validClass) {
                        $(element).addClass('is-invalid');
                    },
                    unhighlight: function (element, errorClass, validClass) {
                        $(element).removeClass('is-invalid');
                    }
                });
            });


        });
    </script>
</body>
</html>