@extends('layouts.user')

@section('css')
<link rel="stylesheet" href="{{asset('assets/plugins/summernote/summernote-bs4.min.css')}}">
@endsection
@section('content')

<div class="row">
    <div class="col-lg-12 col-12">
        <form action="{{asset('pagemanage/saveprivacypolicy')}}" id="quickForm" method="post">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <div class="modal-body">
                <div class="form-group">
                    <label>Enter Privacy Policy</label>
                    <textarea id="texteditor" name="field_value">{{$find?$find->field_value:''}}</textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">Save changes</button>
            </div>
        </form>  
    </div>
</div>
@endsection
@section('script')
<script>
    $('#texteditor').summernote({
        height: 200,
    });

    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
@endsection

