@extends('layouts.user')
@section('css')
<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
    .top {
    margin-bottom: 10px;
}
</style>
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Payout Report</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <form class="form-inline">
            <div class="form-group">
                <label>Form Date </label>
                <input type="date" name="form_date" value="{{request('form_date')}}" class="form-control" />
                <label>To Date </label>
                <input type="date" name="till_date" value="{{request('till_date')}}" class="form-control"/>
            </div>
            <button type="submit" class="btn btn-success">Find</button>
        </form>
    </div>
</div>
<br>
<br>
<div class="row">
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="Datatable" class="table table-bordered table-striped">
                                <thead>
                                    <tr class="seprator">
                                        <th>Member ID</th>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Bank Account No</th>
                                        <th>Bank Name</th>
                                        <th>Branch</th>
                                        <th>IFSC Code</th>
                                        <th>Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; ?>
                                    @foreach($users as $row)
                                    <tr>
                                        <td>{{$row->username}}</td>
                                        <td>{{$row->name}}</td>
                                        <td>{{$row->mobile}}</td>
                                        <?php
                                        $bank = \App\BankAccount::where('user_id', $row->id)->first();
                                        ?>
                                        @if($bank)
                                        <td>{{$bank->number}}</td>
                                        <td>{{$bank->bank_name}}</td>
                                        <td>{{$bank->branch_name}}</td>
                                        <td>{{$bank->ifsc_code}}</td>
                                        @else
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        @endif
                                        <td>
                                            {{App\WalletRequest::amountFormat(\App\Wallet::getWalletblanceDate($row->id,request('form_date'),request('till_date')))}}
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 
@endsection

@section('script')
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script>
$('#Datatable').DataTable({
    dom: '<"top d-flex justify-content-between align-items-center"Bfl>rtip',
    buttons: [
        {
            extend: 'excelHtml5',
            text: 'Excel',
            title: 'Payout Report'
        }
    ],
    lengthMenu: [
        [10, 25, 50, 100, -1],
        [10, 25, 50, 100, "All"]
    ]
});
</script>
@endsection
