@extends('layouts.user')
@section('css')
<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
</style>
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Payout History</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="Datatable_2" class="table table-bordered table-striped">
                                <thead>
                                    <tr class="seprator">
                                        <th>Record DateTime</th>
                                        <th>Payment Date</th>
                                        <th>Member Id</th>
                                        <th>Member Name</th>
                                        <th>Amount</th>
                                        <th>Mode</th>
                                        <th>Remark</th>
                                        <th>Proof</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; ?>
                                    @foreach($users as $row)
                                    <tr>
                                        <td>{{date('d-m-Y H:i',strtotime($row->created_at))}}</td>
                                        <td>{{date('d-m-Y',strtotime($row->payment_date))}}</td>
                                        <td>{{$row->username}}</td>
                                        <td>{{$row->getUser->name}}</td>
                                        <td>{{$row->payment_amount}}</td>
                                        <td>{{$row->payment_mode}}</td>
                                        <td>{{$row->pay_info}}</td>
                                        <td title="View Document" class="pointer">
                                            <a href="{{asset('payment_proof/'.$row->payment_proof)}}" target="_blank"><i class="fa fa-eye" aria-hidden="true" ></i></a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 
@endsection

@section('script')
<script>
    var tabledata = $('#Datatable').DataTable();
    var tabledata2 = $('#Datatable_2').DataTable();
    var tabledata3 = $('#Datatable_3').DataTable();

    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Reject Reason",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Reject it!',
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value != '') {
                        resolve()
                    } else {
                        resolve('Reason Required...')
                    }
                })
            }
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "{{ URL::asset('wallet/rejecteentry') }}",
                    data: {'row_id': $(this).attr('id'), 'reason': result.value},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('click', '.approved_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Text",
            icon: 'success',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Approve it!',
        }).then((result) => {
            $.ajax({
                url: "{{ URL::asset('wallet/approveentry') }}",
                data: {'row_id': $(this).attr('id'), 'reason': result.value},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        });
    });

</script>
@endsection
