@extends('layouts.user')
@section('css')

@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Ad Package to member</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card shadow-lg o-hidden border-0">
            <div class="card-body p-0">
                <div class="row">
                    <div class="col-lg-7">
                        <div class="p-5">
                            <form style="font-weight: bold;" id="activationform" action="{{asset('topuppackages/activemembermanuly')}}" id="quickForm" class="user" method="post" enctype="multipart/form-data">
                                <span class="text-warning">
                                    carefully add User and Select Package.
                                </span>
                                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                <div class="form-group">
                                    <label class="form-label">Enter Member ID</label>
                                    <input id="sponsor_change" class="form-control form-control-user" type="text" placeholder="Username" name="username" required>
                                    <div id="sponsor_response"></div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Select Package</label>
                                    <select class="form-control" name="pack_id">
                                        <option value="">Select One</option>
                                        @foreach($packages as $pack)
                                        <option value="{{$pack->id}}">{{$pack->package_name}} | RS.{{$pack->mrp}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Payment Mode - Cash / Bank Transfer</label>
                                    <select class="form-control" id="changetopup" name="mode" required>
                                        <option value="">Select One</option>
                                        <option value="Bank">Bank Transfer</option>
                                        <option value="Cash">Cash</option>
                                        <option value="Credit">Credit</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label"><strong>Upload Transaction Proof</strong></label>
                                    <input class="form-control form-control-user requiredremove" type="file" placeholder="Transaction ID" name="payment_proof" accept="image/*">
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Remarks</label>
                                    <input class="form-control form-control-user" type="text" placeholder="Remarks" name="reason">
                                </div>
                                <hr>
                                <button class="btn btn-primary d-block btn-user w-100 submit_btn" type="submit">Add</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
    $(document).on('blur', '#sponsor_change', function () {
        if ($(this).val() != '')
        {
            var sponsor = $("#sponsor_change").val().trim();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                url: "{{ asset('frontdata/fetchsponsor2') }}",
                method: "POST",
                data: {sponsor: sponsor, _token: _token},
                success: function (response)
                {
                    if (response) {
                        $("#sponsor_response").html(response);
                    } else {
                        $("#sponsor_response").html('Invalid Sponsor ID');
                    }
                }
            })
        }
    });

    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Reject Reason",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Reject it!',
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value != '') {
                        resolve()
                    } else {
                        resolve('Reason Required...')
                    }
                })
            }
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "{{ URL::asset('topuppackages/rejecteentry') }}",
                    data: {'row_id': $(this).attr('id'), 'reason': result.value},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('click', '.approved_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Text",
            icon: 'success',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Approve it!',
        }).then((result) => {
            $.ajax({
                url: "{{ URL::asset('topuppackages/approveentry') }}",
                data: {'row_id': $(this).attr('id'), 'reason': result.value},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        });
    });

</script>
@endsection
