@extends('layouts.user')

@section('css')

@endsection
@section('content')

<div class="row">
    <div class="col-lg-12 col-12">
        <button class="btn btn-success" id="openaddmodel">
            Add Faqs <i class="fas fa-plus"></i>
        </button>
        <br>
        <br>
        <table id="Datatable" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Question</th>
                    <th>Ans</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>

            </tbody>
        </table>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="openaddmodelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Faqs</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{asset('pagemanage/savefaqs')}}" id="quickForm" method="post">
                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                <input type="hidden" name="update_id" value="" />
                <div class="modal-body">
                    <div class="form-group">
                        <label>Enter Question</label>
                        <input type="text" class="form-control" name="question" placeholder="Enter Question" required>
                    </div>
                    <div class="form-group">
                        <label>Enter Answer</label>
                        <textarea id="texteditor" name="ans" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save Data</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    var tabledata = $('#Datatable').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{asset("pagemanage/faqsdata")}}',
        columns: [
            {data: 'question', name: 'question'},
            {data: 'ans', name: 'ans'},
            {data: 'action', name: 'action', orderable: false, searchable: false, width: '100px'}
        ]
    });

    $(document).on('click', '#openaddmodel', function () {
        $('#texteditor').summernote({
            height: 200,
        });
        $('#openaddmodelModal').modal('show');
    });
    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "{{ URL::asset('pagemanage/savefaqs') }}",
                    data: {delete_row: 'delete_row', 'row_id': $(this).attr('id')},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        tabledata.draw();
                    },
                    cache: false,
                });
            }
        });
    });
    $(document).on('click', '.update_btn', function () {
        $.ajax({
            url: "{{ URL::asset('pagemanage/savefaqs') }}",
            data: {edit_data: 'edit_data', 'row_id': $(this).attr('id')},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {
                $(document).find("input[name='update_id']").val(data.row.id);
                $(document).find("input[name='question']").val(data.row.question);
                $('#texteditor').summernote('code', data.row.ans);
                $('#openaddmodelModal').modal('show');
            },
            cache: false,
        });
    });
    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
@endsection

