@extends('layouts.user')
@section('css')
<link rel="stylesheet"
      href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">

<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
    .dt-buttons{
        float: right !important;
    }
    .dt-button{
        color: #000;
        background: #fff;
    }

</style>
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">User All Income Till Date Report</h1>
</div>
<div class="row d-none">
    <div class="col-md-12">
        <form class="form-inline">
            <div class="form-group">
                <label>Form Date </label>
                <input type="date" name="form_date" value="{{request('form_date')}}" class="form-control" />
                <label>To Date </label>
                <input type="date" name="till_date" value="{{request('till_date')}}" class="form-control"/>
            </div>
            <button type="submit" class="btn btn-success">Find</button>
        </form>
    </div>
</div>
<br>
<br>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <a href="{{asset('reports/alluserincomedataexport')}}" class="btn btn-primary float-right"><i class="fa fa-file-excel-o"></i>Export</a>
                <br>
                <br>
                <div class="table-responsive">
                    <table id="Datatable" class="table table-bordered table-striped">
                        <thead>
                            <tr class="seprator">
                                <th>Member Id</th>
                                <th>Member Name</th>
                                <th>Phone Number</th>
                                <th>Joining Date</th>
                                <th>Activation Date</th>
                                <th>Status</th>
                                <th>Amount Invested</th>
                                <th>Direct</th>
                                <th>ROI</th>
                                <th>Level On ROI</th>
                                <th>Total Income</th>
                                <th>Total Deductions</th>
                                <th>Net Amount</th>
                                <th>Amount Paid</th>
                                <th>Balance To Be Paid</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')

<!-- Buttons JS -->
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<!-- Excel dependency -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script>
$('#Datatable').DataTable({
    processing: true,
    serverSide: true,
    ajax: {
        url: "{{ url('reports/alluserincomedata') }}",
        data: function (d) {
            d.from_date = $('#from_date').val();
            d.till_date = $('#till_date').val();
        }
    },
    columns: [
        { data: 'username' },
        { data: 'name'},
        { data: 'mobile'},
        { data: 'created_at'},
        { data: 'activation_date'},
        { data: 'active'},
        { data: 'invested'},
        { data: 'direct'},
        { data: 'roi' },
        { data: 'levelroi' },
        { data: 'total' },
        { data: 'deductions'},
        { data: 'net' },
        { data: 'paid' },
        { data: 'balance' }
    ]
});
</script>
@endsection
