<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\User;

class Tree extends Model {

    protected $table = 'users';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    //protected $fillable = ['user_id', 'type', 'file', 'status'];

    protected $guarded = array();

    public function user($id) {
        $user = User::find($id);
        if ($user) {
            return $user->username;
        }
    }

    public function children() {
        return $this->hasMany('App\Tree', 'sponser_id', 'id');
    }

    public function getsponsorid() {
        return $this->belongsTo('App\User', 'sponser_id', 'id');
    }

    public function getUser() {
        return $this->belongsTo('App\User', 'user_id', 'id');
    }

    public function getDetails() {
        return $this->belongsTo('App\Detail', 'sponser_id', 'id');
    }

    public function findCusUserProductValue($id) {
        $pin = Pin::where('user_user', $id)->first();
        if ($pin) {
            $product = Product::find($pin->product_id);
            if ($product) {
                return $product->mrp;
            }
        }
    }

    static function getTotalTeam($placed_id) {
        $userlist = User::whereIn('placed_id', $placed_id)->orderBy('id', 'asc')->pluck('id', 'id')->all();
        $html = $userlist;
        if (count($userlist) > 0) {
            $html += self::getTotalTeam($userlist);
        }
        return $html;
    }

    static function getTotalTeambyposition($placed_id, $position) {
        $userlist = User::whereIn('placed_id', $placed_id)->where('position_number', $position)->orderBy('id', 'asc')->pluck('id', 'id')->all();
        $html = $userlist;
        if (count($userlist) > 0) {
            $html += self::getTotalTeam($userlist);
        }
        return $html;
    }

    public function getTeamcount($sponser_id, $tree, $postion) {
        $tree = $sponser_id . ',';
        $result = Tree::where('sponser_id', $sponser_id)->orderBy('position_number')->get();
        if ($result->count() != 0) {
            foreach ($result as $child) {
                if ($child->id != 0) {
                    $tree .= $this->getTeamcount($child->id, $tree, $postion);
                }
            }
        }
        return $tree;
    }

    public function getTree($sponser_id, $count) {
        $count += 1;

        $tree = '<ul class="tree-center">';
        $user = User::where('id', $sponser_id)->first();

        $result = User::where('sponser_id', $sponser_id)
                        ->select('id', 'sponser_id')
                        ->orderBy('sponser_id')->pluck('id', 'id')->all();

        if (count($result) == 0) {
            
        } else {
            foreach ($result as $key => $a) {
                $child = User::where('id', $a)->first();
                $name = $child->name . ' ' . $child->last_name;
                $m_id = $child->username;

                $getsponsorid = $child->sponser;
                $getsponsorname = $child->getsponsorid ? $child->getsponsorid->name . ' ' . $child->getsponsorid->last_name : '';

                $placeunder_id = $child->placed_under;
                $placeunder = User::where('username', $placeunder_id)->first();
                $placeunderid = $placeunder ? $placeunder->username : '';
                $placeundername = $placeunder ? $placeunder->name . ' ' . $placeunder->last_name : '';

                $product_name = '';

                $title = 'Member Id : ' . $m_id;
                $title .= '&#13;Member Name : ' . $name;
                $title .= '&#13;Investment : ' . \App\WalletRequest::where('status', 1)->where('user_id', $a)->sum('amount');
                $title .= '&#13;Date Of Join : ' . date('d-M-Y', strtotime($child->created_at));

                $tree .= '<li><a href=' . asset('reports/myteam?usertree=' . $m_id) . ' style="border-color:green;" data-toggle="popover" title="' . $title . '">
                                <img src="' . asset('filled.png') . '"/><br>
                            ' . $m_id . '</a>';
                /*


                  if ($count <= 3) {
                  $tree .= $this->getTree($child->id, $count);
                  }
                 * 
                 */
                $tree .= '</li>';
            }
        }

        $tree .= '</ul>';
        return $tree;
    }

    public function getTreeList($sponser_id, $count) {
        $count += 1;

        $tree = '<ul>';
        $user = User::where('id', $sponser_id)->first();
        $result = User::where('sponser_id', $sponser_id)
                        ->select('id', 'sponser_id')
                        ->orderBy('sponser_id')->pluck('id', 'id')->all();

        foreach ($result as $key => $a) {
            $child = User::where('id', $a)->first();
            $name = $child->name . ' ' . $child->last_name;
            $m_id = $child->username.' - '.$name;
            $tree .= '<li data-jstree="{ "selected" : true }">' . $m_id;
            $tree .= self::getTreeList($a, $count);
            $tree .= '</li>';
        }

        $tree .= '</ul>';
        return $tree;
    }

    public function childs() {
        return $this->hasMany(Tree::class, 'sponser_id', 'user_id');
    }

    public function child() {
        return $this->hasMany(Tree::class, 'sponser_id', 'user_id');
    }

}
