<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SupportComment extends Model {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'support_comment';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['support_id','user_id', 'comment', 'flag'];

    //protected $guarded = array();

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    public function getUser() {
        return $this->belongsTo('App\User', 'user_id', 'id');
    }
}
