<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class KycDetails extends Model {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'kyc_details';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['user_id', 'type', 'file', 'status'];

    //protected $guarded = array();

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

}
