<?php

namespace App\Http\Controllers;

use Razorpay\IFSC\Client;
use Auth;
use App\Bank;
use Illuminate\Http\Request;
use App\Wallet;
use App\CashWallet;
use App\CashRequest;
use Yajra\DataTables\DataTables;
use Maatwebsite\Excel\Concerns\FromArray;
use App\Payment;

class WalletController extends Controller {
    /**
     * Show bank details
     */

    /**
     * Show a form to create bank details
     */
    public function __construct() {
        $this->middleware('auth');
    }

    public function getAllwalletreport(Request $request) {
        $data['page_header'] = 'My Fund Wallet';
        $data['total_blance'] = \App\FundWallet::getWalletblance(\Auth::user()->id);
        $data['user_data'] = \App\User::find(\Auth::user()->id);

        return view('fund_wallet', $data)->with('user_id', \Auth::user()->id);
    }

    public function getMywallethistory(Request $request) {
        if (request('user_id')) {
            $data = Wallet::where('user_id', request('user_id'))->orderBy('created_at');
        } else {
            $data = Wallet::where('user_id', \Auth::user()->id)->orderBy('created_at');
        }
        $data = $data->select('id', 'user_id', 'flag', 'text', 'pay_date', 'pay_mode', 'pay_id', 'pay_info', 'created_at', 'total_amount')->get();

        return Datatables::of($data)
                        ->editColumn('total_amount', function($row) {
                            if ($row->flag == 0) {
                                $html = '<i class="fas fa-plus" style="color:green;"></i> ';
                            } else {
                                $html = '<i class="fas fa-minus" style="color:red;"></i> ';
                            }
                            return $html . \App\WalletRequest::amountFormat($row->total_amount);
                        })
                        ->editColumn('created_at', function($row) {
                            return date('d/m/Y', strtotime($row->created_at));
                        })
                        ->rawColumns(['total_amount'])
                        ->make(true);
    }

    public function getMywithdrawalwallethistory(Request $request) {
        if (request('user_id')) {
            $data = CashWallet::where('user_id', request('user_id'))->orderBy('created_at');
        } else {
            $data = CashWallet::where('user_id', \Auth::user()->id)->orderBy('created_at');
        }
        $data = $data->select('id', 'user_id', 'flag', 'text', 'pay_date', 'pay_mode', 'pay_id', 'pay_info', 'created_at', 'total_amount')->get();

        return Datatables::of($data)
                        ->editColumn('total_amount', function($row) {
                            if ($row->flag == 0) {
                                $html = '<i class="fas fa-plus" style="color:green;"></i> ';
                            } else {
                                $html = '<i class="fas fa-minus" style="color:red;"></i> ';
                            }
                            return $html . \App\WalletRequest::amountFormat($row->total_amount);
                        })
                        ->editColumn('created_at', function($row) {
                            return date('d/m/Y', strtotime($row->created_at));
                        })
                        ->rawColumns(['total_amount'])
                        ->make(true);
    }

    public function getMyfundwallethistory(Request $request) {
        if (request('user_id')) {
            $data = \App\FundWallet::where('user_id', request('user_id'))->orderBy('created_at');
        } else {
            $data = \App\FundWallet::where('user_id', \Auth::user()->id)->orderBy('created_at');
        }
        $data = $data->select('id', 'user_id', 'flag', 'text', 'pay_date', 'pay_mode', 'pay_id', 'pay_info', 'created_at', 'total_amount')->get();

        return Datatables::of($data)
                        ->editColumn('total_amount', function($row) {
                            if ($row->flag == 0) {
                                $html = '<i class="fas fa-plus" style="color:green;"></i> ';
                            } else {
                                $html = '<i class="fas fa-minus" style="color:red;"></i> ';
                            }
                            return $html . \App\WalletRequest::amountFormat($row->total_amount);
                        })
                        ->editColumn('created_at', function($row) {
                            return date('d/m/Y', strtotime($row->created_at));
                        })
                        ->rawColumns(['total_amount'])
                        ->make(true);
    }

    public function getWithdrawalrequest(Request $request) {
        $data['page_header'] = 'My Withdrawal';

        $data['cash_amount'] = round(\App\Wallet::getWalletblance(\Auth::user()->id));

        $data['my_banks'] = \App\BankAccount::where('user_id', \Auth::user()->id)->get();
        $data['my_direct'] = \App\User::where('sponser_id', \Auth::user()->id)->get()->count();

        $data['user'] = \App\User::where('id', 1)->first();

        return view('withdrawalpage', $data)->with('user_id', \Auth::user()->id);
    }

    public function getWithdrawalreport(Request $request) {
        $data['page_header'] = 'My Withdrawal';
        $data['cash_amount'] = round(\App\Wallet::getWalletblance(\Auth::user()->id));

        $data['my_banks'] = \App\BankAccount::where('user_id', \Auth::user()->id)->get();
        $data['my_direct'] = \App\User::where('sponser_id', \Auth::user()->id)->get()->count();

        return view('withdrawal_report', $data)->with('user_id', \Auth::user()->id);
    }

    public function getWithdrawal(Request $request) {
        if (request('user_id')) {
            $data = CashRequest::where('user_id', request('user_id'))->orderBy('created_at')->get();
        } else {
            $data = CashRequest::where('user_id', \Auth::user()->id)->orderBy('created_at')->get();
        }

        return Datatables::of($data)
                        ->addColumn('bank_id', function($row) {
                            $bank = \App\BankAccount::find($row->bank_id);
                            if ($bank) {
                                $html = 'holder name : ' . $bank->holder_name . '<br>';
                                $html .= 'bank name : ' . $bank->bank_name . '<br>';
                                $html .= 'Account No. : ' . $bank->number . '<br>';
                                $html .= 'branch name : ' . $bank->branch_name . '<br>';
                                $html .= 'ifsc_code : ' . $bank->ifsc_code . '<br>';
                                return $html;
                            }
                            return '';
                        })
                        ->editColumn('status', function($row) {
                            if ($row->status == 0) {
                                $html = '<span class="text-warning">Pending</span>';
                            } else if ($row->status == 1) {
                                $html = '<span class="text-success">Approved</span>';
                            } else {
                                $html = '<span class="text-danger">Rejected</span>';
                            }
                            return $html;
                        })
                        ->editColumn('created_at', function($row) {
                            return date('d/m/Y', strtotime($row->created_at));
                        })
                        ->editColumn('payment_proof', function($row) {
                            if ($row->payment_proof) {
                                return '<a href="' . asset('payment_proof/' . $row->payment_proof) . '" target="_blank"><i class="fa fa-eye" aria-hidden="true" ></i></a>';
                            }
                            return '';
                        })
                        ->rawColumns(['status', 'payment_proof', 'bank_id'])
                        ->make(true);
    }

    public function postCheckcashrequest(Request $request) {
        if (\App\CashWallet::getWalletblance(\Auth::user()->id) > request('value')) {
            $wallet = request('value');
            $amount = $wallet;
            $amount_reciev = $wallet;
            return \Response::json(['amount' => $amount_reciev]);
        }
        return \Response::json(['amount' => 0]);
    }

    function postCashrequest(Request $request) {

        $total = \App\Wallet::getWalletblance(\Auth::user()->id);
        if ($total < request('amount')) {
            return back()->with('error', 'Amount Not Valid..');
        }

        try {
            $user = \App\User::find(\Auth::user()->id);
            $wallet = request('amount');
            $amount_sc = $wallet;
            $amount_reciev = $wallet;

            $payment = new \App\CashRequest();
            $payment->user_id = $user->id;
            $payment->bank_id = $request->bank_id;
            $payment->amount = $request->amount;
            $payment->cash_amount = $amount_reciev;
            $payment->address = $request->address;
            $payment->status = 0;
            $payment->save();

//            $text = 'Send Cash Request to Admin';
//            \App\CashWallet::create(['user_id' => $user->id, 'amount' => request('amount'), 'total_amount' => request('amount'), 'flag' => 1, 'text' => $text]);
        } catch (Exception $e) {
            return back()->with('error', $e);
        }
        return back()->with('success', 'Request Sended..');
    }

    function getCashrequestadmin() {
        $data['panding'] = \App\CashRequest::where('status', 0)->get();
        $data['approved'] = \App\CashRequest::where('status', 1)->get();
        $data['rejected'] = \App\CashRequest::where('status', 2)->get();
        return \View::make('admin.cash_request_admin', $data);
    }

    function getPaymentform() {
        $data['users'] = \App\User::where('active', 1)->get();

        return \View::make('admin.payout_form', $data);
    }

    function postCheckuser(Request $request) {
        $user = \App\User::where('username', request('username'))->first();
        if ($user) {
            $name = '<span class="badge badge-success">User Name : ' . $user->name . '</span>';
            $blance = \App\WalletRequest::amountFormat(\App\Wallet::getWalletblance($user->id));
            return \Response::json(['name' => $name, 'blance' => $blance]);
        }
        return \Response::json(['name' => '<span class="badge badge-danger">User Id Invalid.</span>']);
    }

    function getPayouthistory() {

        $data['users'] = \App\Payments::all();

        return \View::make('admin.payout_history', $data);
    }

    function getPayoutreport() {
        $userids = \App\Wallet::groupBy('user_id')->pluck('user_id');
        $data['users'] = \App\User::whereIn('id', $userids)->where('role',2)->get();

        return \View::make('admin.payout_report', $data);
    }

    function getApprovecashrequest($id) {
        $data['record'] = \App\CashRequest::where('id', $id)->first();

        return \View::make('admin.cash_request_approve', $data);
    }

    function postApprovecashrequestsave(Request $request) {
        $request->validate([
            'payment_proof' => 'mimes:png,jpg,jpge',
        ]);
        $user = \App\User::where('username', $request->username)->first();
        try {
            $retun = \DB::transaction(function()use($request, $user) {
                        $payment_proof = null;
                        if ($request->hasFile('payment_proof')) {
                            $file = $request->file('payment_proof');
                            $destinationPath = public_path() . '/payment_proof/';
                            $payment_proof = \Str::random(10) . '.' . $file->getClientOriginalExtension();
                            $file->move($destinationPath, $payment_proof);
                        }
                        if ($user) {
                            $text = 'Withdrawal Request Approved';

                            \App\Wallet::create(['user_id' => $user->id, 'amount' => $request->payment_amount,
                                'total_amount' => $request->payment_amount, 'flag' => 1,
                                'text' => 'Admin Transfer By ' . $request->payment_mode]);
                            if (request('cashrequest') == 'cashrequest') {
                                \App\CashRequest::where('id', request('cash_id'))
                                        ->update(['status' => 1, 'reason' => $request->pay_info, 'payment_proof' => $payment_proof]);
                            }
                            \App\Payments::create(['user_id' => $user->id, 'username' => $user->username,
                                'payment_amount' => $request->payment_amount, 'payment_date' => $request->payment_date, 'payment_mode' => $request->payment_mode,
                                'payment_proof' => $payment_proof, 'pay_info' => $request->pay_info]);
                        }
                    });
            if (request('cashrequest') == 'cashrequest') {
                return \Redirect::to('wallet/cashrequestadmin')->with('success', 'Approved Successfully...');
            }
            return \Redirect::back()->with('success', 'Approved Successfully...');
        } catch (Exception $ex) {
            return \Redirect::back()->with('error', 'Whoops, looks like something went wrong.');
        }
    }

    function postRejecteentry(Request $request) {
        $find = \App\CashRequest::where('id', $request->row_id)->first();
        if ($find) {
//            $text = 'Withdrawal Request Declined Amount refunded';
//            \App\CashWallet::create(['user_id' => $find->user_id, 'amount' => $find->amount, 'total_amount' => $find->amount, 'flag' => 0, 'text' => $text]);
            $find->update(['status' => 2, 'reason' => $request->reason, 'date_time' => date('Y-m-d H:i:s')]);
        }
        return \Response::json(['code' => 200]);
    }

}
