<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\View\View;
use Yajra\DataTables\DataTables;
use App\User;
use App\Bank;
use App\State;

class UserManageController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    function getAddnew() {
        $data['page_header'] = 'User Management';
        $data['packages'] = \App\Product::whereNotIn('package_name', ['Package-1'])->get();
        $data['banks'] = Bank::all();
        return \View::make('admin.usermanage.addnew', $data);
    }

    public function genTpassword() {
        $password = "";
        for ($i = 0; $i < 6; $i++) {
            $password .= rand(1, 9);
        }
        return $password;
    }

    public function postRegistermanuly(Request $request) {

        $refferal = User::where('username', request('sponser'))->first();
        if (!$refferal) {
            return \Redirect::back()->with('error', 'Referred By Not Valid...');
        }
        $mobile = User::where('mobile', request('mobile'))->first();
        if ($mobile) {
            return \Redirect::back()->with('error', 'Mobile Number. Already Registered....');
        }
        if (request('email')) {
            $email = User::where('email', request('email'))->first();
            if ($email) {
                return \Redirect::back()->with('error', 'E-Mail Already Registered....');
            }
        }
        if (request('email')) {
            $this->validate($request, [
                'name' => 'required',
                'email' => 'email|required|',
                'mobile' => 'required|max:10|',
                //'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
                //'password_confirmation' => 'min:6',
                'sponser' => 'required|exists:users,username'
            ]);
        } else {
            $this->validate($request, [
                'name' => 'required',
                'mobile' => 'required|max:10|',
                //'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
                //'password_confirmation' => 'min:6',
                'sponser' => 'required|exists:users,username'
            ]);
        }

        $useridd = \DB::transaction(function()use($request) {

                    $refferal = User::where('username', request('sponser'))->first();

                    $join_date = date('Y-m-d H:i:s', strtotime(request('created_at')));
                    $package_date = date('Y-m-d H:i:s', strtotime(request('created_at_package')));

                    $user = new User();
                    $user->name = $request->name;
                    $user->email = $request->email;
                    $user->country_code = $request->country_code;
                    $user->mobile = $request->mobile;
                    $user->role = 2;
                    $user->placed_id = 0;
                    $user->position_number = 0;
                    $pass = $this->genTpassword();
                    $user->password_text = $pass;
                    $user->password = bcrypt($pass);
                    $user->tpass = $this->genTpassword();
                    $user->sponser = $refferal->username;
                    $user->sponser_id = $refferal->id;
                    $user->country = $request->country;
                    $user->state = $request->state;
                    $user->active = 1;
                    $user->created_at = $join_date;
                    $user->updated_at = $join_date;
                    $user->save();

                    $member = User::find($user->id);
                    $recordnum = $member->id;
                    $recordid = str_pad($recordnum, 4, 0, STR_PAD_LEFT);
                    $useridd = 'MT' . $recordid;

                    $useridd = $this->generateUniqueUsername();

                    $member->username = $useridd;
                    $member->save();

                    $find = \App\Product::where('id', request('pack_id'))->first();
                    if ($find) {
                        $package = new \App\WalletRequest();
                        $package->package_id = $find->id;
                        $package->user_id = $user->id;
                        $package->package_name = $find->package_name;
                        $package->amount = $find->mrp;
                        $package->roi_per = $find->roi_per;
                        $package->number_of_day = $find->number_of_day;
                        $package->status = 1;
                        $package->reason = 'Added This Direct User Register By Admin';
                        $package->approve_date = $join_date;
                        $package->created_at = $join_date;
                        $package->updated_at = $join_date;
                        $package->save();
                    }
                    return $useridd;
                });
        return \Redirect::to('home')->with('success', 'Account Created Successfully... Your UserID - ' . $useridd . ' Store Safe Place.');
    }

    function generateUniqueUsername() {
        do {
            $username = 'MTN' . str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
        } while (User::where('username', $username)->exists());

        return $username;
    }

    function getIndex() {
        $data['page_header'] = 'User Management';
        return \View::make('admin.usermanage.index', $data);
    }

    function getData($status) {

        $users = User::where('role', 2);

        $credited = \App\WalletRequest::where('mode', 'Credit')->pluck('user_id', 'user_id')->all();
        if ($status == 'credited') {
            $users = $users->whereIn('id', $credited);
        } else {
            $users = $users->where('active', $status);
        }

        $users = $users->select(['users.id', 'username', 'name', 'last_name', 'email', 'mobile', 'password_text', 'tpass', 'sponser_id', 'sponser', 'placed_under', 'position', 'users.created_at', 'users.active', 'suspend'])->get();
        return Datatables::of($users)
                        ->editColumn('invseted', function($row) {
                            return \App\WalletRequest::where('user_id', $row->id)->where('status', 1)->sum('amount');
                        })
                        ->editColumn('name', function($row) {
                            return $row->name . ' ' . $row->last_name;
                        })
                        ->editColumn('sponser', function($row) {
                            if ($row->getsponsorid) {
                                $html = $row->getsponsorid ? $row->getsponsorid->username : $row->sponser;
                                //$html2 = $row->getsponsorid->name . ' ' . $row->getsponsorid->last_name;

                                return $html;
                            }
                            return '';
                        })
                        ->editColumn('active', function($row) {
                            if ($row->active == 0) {
                                return '<span class="badge badge-danger">Inactive</span>';
                            }
                            return '<span class="badge badge-success">Active</span>';
                        })
                        ->editColumn('password_text', function($row) {
                            return $row->password_text . '<br>' . $row->tpass;
                        })
                        ->addColumn('action', function ($user) {
                            $html = '<a href="' . asset('usermanage/details/' . $user->id) . '" class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></a>';
                            $html .= '<a href="' . asset('usermanage/changeuserpassword?user_id=' . $user->id) . '" class="btn btn-sm btn-info"><i class="fas fa-key"></i></a>';
                            $html .= '<a href="' . asset('reports/myteam?usertree=' . $user->username) . '" class="btn btn-sm btn-warning"><i class="fas fa-sitemap"></i></a>';
                            if ($user->suspend == 0) {
                                $html .= '<button class="btn btn-sm btn-danger setinactiveuser" id="' . $user->id . '">Suspend</button>';
                            } else {
                                $html .= '<button class="btn btn-sm btn-success setreactiveinactiveuser" id="' . $user->id . '">Un Suspend</button>';
                            }
                            $html .= '<a href="' . asset('topuppackages/userpackages/' . $user->id) . '" class="btn btn-sm btn-info">Invest Details</a>';
                            return $html;
                        })
                        ->editColumn('created_at', function($row) {
                            return date('d F Y', strtotime($row->created_at));
                        })
                        ->rawColumns(['action', 'username', 'password_text', 'active', 'sponser', 'packages'])
                        ->make(true);
    }

    function postInactiveuser() {
        $user = User::find(request('row_id'));
        if ($user) {
            $user->update(['suspend' => 1]);
        }
    }

    function postReinactiveuser() {
        $user = User::find(request('row_id'));
        if ($user) {
            $user->update(['suspend' => 0]);
        }
    }

    function getProfile() {
        $data['page_header'] = 'User Profile';
        $user_id = \Auth::user()->id;
        $data['user'] = User::find($user_id);
        $data['banks'] = Bank::all();
        if ($data['user']) {
            return view('profile', $data);
        }
    }

    function getDetails($id) {
        $data['page_header'] = 'User Profile';
        $user_id = $id;
        $data['user'] = User::find($user_id);
        $data['banks'] = Bank::all();
        if ($data['user']) {
            return view('profile', $data);
        }
    }

    function postChangeposition(Request $request) {
        $user = User::find(\Auth::user()->id);
        if ($user) {
            $user->update(['set_position' => request('set_position')]);
        }
        return \Redirect::back();
    }

    function postChangeprofileimage(Request $request, $id) {
        $request->validate([
            'profile_image' => 'required|mimes:png,jpg,jpge',
        ]);

        $user = User::where('id', $id)->first();
        if ($user) {
            if ($request->hasFile('profile_image')) {

                $destinationPath = public_path() . '/profile_image/' . $user->profile_image;
                \File::delete($destinationPath);

                $file = $request->file('profile_image');
                $destinationPath = public_path() . '/profile_image/';
                $filename1 = \Str::random(10) . '.' . $file->getClientOriginalExtension();

                $file->move($destinationPath, $filename1);



                $user->update(['profile_image' => $filename1]);
            }
        }

        return \Redirect::back();
    }

    public function postUpdateuser($id, Request $request) {

        $this->validate($request, [
//            'username' => 'required|alpha_dash|unique:users,username,' . $id,
            'name' => 'required',
//            'pan_no' => 'required',
            //'email' => 'required|email|unique:users,email,' . $id,
            'mobile' => 'required|max:10|unique:users,mobile,' . $id,
        ]);

        if (request('pan_no')) {
            $pan = User::where('pan_no', request('pan_no'))->where('id', '!=', $id)->get()->count();
            if ($pan >= 3) {
                return \Redirect::back()->with('error', 'Same PAN no. Use 3 times! Update Other...');
            }
        }
        $ok = \DB::transaction(function()use($request, $id) {
                    $detail = User::where('id', $id)->first();
                    if ($detail) {
//                        $detail->username = $request->username;
                        $detail->name = $request->name;
                        $detail->last_name = $request->last_name;
                        $detail->email = $request->email;
                        $detail->pan_no = $request->pan_no;
                        $detail->mobile = $request->mobile;
                        $detail->boold_group = $request->boold_group;
                        $detail->save();
                    }
                    return 1;
                });
        if ($ok == 1) {
            return \Redirect::back()->with('success', 'Member Details Updated Successfully');
        }
        return \Redirect::back()->with('error', 'Request Could not be processed');
    }

    public function postUpdateuseraddress($id, Request $request) {

        $ok = \DB::transaction(function()use($request, $id) {
                    $detail = User::where('id', $id)->first();
                    if ($detail) {
//                        $detail->username = $request->username;
                        $detail->state = $request->state;
                        $detail->district = $request->district;
                        $detail->city = $request->city;
                        $detail->pin_code = $request->pin_code;
                        $detail->address = $request->address;
                        $detail->save();
                    }
                    return 1;
                });
        if ($ok == 1) {
            return \Redirect::back()->with('success', 'Address Details Updated Successfully');
        }
        return \Redirect::back()->with('error', 'Request Could not be processed');
    }

    public function postUpdatetoken($id, Request $request) {

        $this->validate($request, [
            'token' => 'required'
        ]);

        $ok = \DB::transaction(function()use($request, $id) {
                    $detail = User::where('id', $id)->first();
                    if ($detail) {
                        $detail->token = $request->token;
                        $detail->save();
                    }
                    return 1;
                });
        if ($ok == 1) {
            return \Redirect::back()->with('success', 'Wallet Address Updated Successfully');
        }
        return \Redirect::back()->with('error', 'Request Could not be processed');
    }

    public function getChangepassword(Request $request) {
        $data['page_header'] = 'Chane Password';
        $data['user'] = User::find(\Auth::user()->id);
        return view('changepass', $data);
    }

    public function getChangeuserpassword(Request $request) {
        $data['page_header'] = 'Chane Password';
        $data['user'] = User::find(request('user_id'));
        return view('admin.usermanage.changepass', $data);
    }

    public function postSavepass(Request $request) {
        $request->validate([
            'old_password' => 'required',
            'password' => 'required|min:5|confirmed',
            'password_confirmation' => 'required'
        ]);
        $user = \App\User::where('id', request('user_pass_id'))->first();
        if ($user) {
            if ($request->old_password != $user->password_text) {
                return \Redirect::back()->with('error', 'Your Old Password Not Matched.');
            }
            $password = $request->password;
            $user->password_text = $password;
            $user->password = bcrypt($password);
            $user->save();
            return \Redirect::back()->with('success', 'Your Login Password Changed. - ' . $password);
        } else {
            return \Redirect::back()->with('error', 'Something is wrong...');
        }
    }

    public function postSavetranpass(Request $request) {
        $request->validate([
            'old_password' => 'required',
            'password' => 'required|min:4|confirmed',
            'password_confirmation' => 'required'
        ]);
        $user = \App\User::where('id', request('user_pass_id'))->first();
        if ($user) {
            if ($request->old_password != $user->tpass) {
                return \Redirect::back()->with('error', 'Your Old Transaction Password Not Matched.');
            }
            $password = $request->password;
            $user->tpass = $password;
            $user->save();

            return \Redirect::back()->with('success', 'Your Transaction Password Changed. - ' . $password);
        } else {
            return \Redirect::back()->with('error', 'Something is wrong...');
        }
    }

    function getBankdata($user_id) {

        $users = \App\BankAccount::where('user_id', $user_id)
                        ->select(['id', 'user_id', 'number', 'holder_name', 'bank_name', 'branch_name', 'ifsc_code',
                            'payment_type', 'platform_name', 'wallet_address'])->get();
        return Datatables::of($users)
                        ->editColumn('holder_name', function ($user) {
                            return $user->holder_name ? $user->holder_name : $user->platform_name;
                        })
                        ->editColumn('number', function ($user) {
                            return $user->number ? $user->number : $user->wallet_address;
                        })
                        ->addColumn('action', function ($user) {
                            return '<a href="javascript:;" class="btn  btn-outline-primary update_btn" id="' . $user->id . '"><i class="fas fa-edit"></i></a>
                            <a href="javascript:;" class="btn btn-outline-danger delete_btn" id="' . $user->id . '"><i class="fas fa-trash-alt"></i></a>';
                        })
                        ->rawColumns(['question', 'ans', 'action'])
                        ->make(true);
    }

    function postSavebankdetails(Request $request, $user_id) {
        if (request('delete_row') == 'delete_row') {
            $find = \App\BankAccount::where('id', request('row_id'))->where('user_id', $user_id)->first();
            if ($find) {
                //$find->delete();
                $find->forceDelete();
            }
            return \Response::json(['code' => 'ok']);
        }
        if (request('edit_data') == 'edit_data') {
            $find = \App\BankAccount::where('id', request('row_id'))->where('user_id', $user_id)->first();
            if ($find) {
                return \Response::json(['row' => $find]);
            }
            return \Response::json(['code' => 'ok']);
        }
        if (request('update_id')) {
            $find = \App\BankAccount::where('id', request('update_id'))->where('user_id', $user_id)->first();
            if ($find) {
                $find->update([
                    'number' => $request->account_number ? $request->account_number : '',
                    'holder_name' => $request->payee_name ? $request->payee_name : '',
                    'branch_name' => $request->branch ? $request->branch : '',
                    'ifsc_code' => $request->ifsc ? $request->ifsc : '',
                    'bank_name' => $request->bank_name,
                    'payment_type' => $request->payment_type,
                    'platform_name' => $request->platform_name,
                    'wallet_address' => $request->wallet_address,
                ]);
                return \Redirect::back()->with('success', 'Bank Details Update Successfully');
            }
        }
        \App\BankAccount::create([
            'user_id' => $user_id,
            'number' => $request->account_number ? $request->account_number : '',
            'holder_name' => $request->payee_name ? $request->payee_name : '',
            'branch_name' => $request->branch ? $request->branch : '',
            'ifsc_code' => $request->ifsc ? $request->ifsc : '',
            'bank_name' => $request->bank_name,
            'payment_type' => $request->payment_type,
            'platform_name' => $request->platform_name,
            'wallet_address' => $request->wallet_address,
        ]);
        return \Redirect::back()->with('success', 'Bank Details Added Successfully');
    }

}
