<?php

namespace App\Http\Controllers;

use Auth;
use App\Bank;
use Illuminate\Http\Request;
use App\CommonSetting;
use App\Support;
use Yajra\DataTables\DataTables;

class SupportController extends Controller {
    /**
     * Show bank details
     */

    /**
     * Show a form to create bank details
     */
    function getFaqs() {
        $data['page_header'] = 'FAQ';
        $data['faqs'] = \App\Faqs::all();
        return \View::make('pages.userfaqs', $data);
    }

    public function getPlan() {
        $data['page_header'] = 'Our Business Plan';
        return view('pages.plan', $data);
    }

    public function getTerm() {
        $data['page_header'] = 'Terms & Conditions';
        $data['find'] = CommonSetting::where('field_name', 'termcondition')->first();
        return view('admin.term', $data);
    }

    public function getPrivacy() {
        $data['page_header'] = 'Privacy Policy';
        $data['find'] = CommonSetting::where('field_name', 'privacypolicy')->first();
        return view('admin.privacy', $data);
    }

    public function getMessage() {
        $data['page_header'] = 'Message';
        return view('support.index', $data);
    }

    public function getRequestlist() {
        $data['page_header'] = 'Support Request';
        return view('support.requestlist', $data);
    }

    public function getMessageview($id) {
        $data['page_header'] = 'Message Details';
        $data['support'] = Support::where('id', $id)->first();
        if ($data['support']->flag == 0) {
            if (\Auth::user()->role == 1) {
                $data['support']->update(['flag' => 1]);
            }
        }
        \App\SupportComment::where('support_id', $data['support']->id)->where('flag', 0)->where('user_id', '!=', \Auth::user()->id)->update(['flag' => 1]);
        $data['support_comments'] = \App\SupportComment::where('support_id', $data['support']->id)->get();
        return view('support.view', $data);
    }

    function getUserdata() {
        $users = Support::where('user_id', \Auth::user()->id)->select(['id', 'query', 'msg', 'created_at'])->get();
        return Datatables::of($users)
                        ->editColumn('created_at', function ($data) {
                            return date('d-m-Y H:i', strtotime($data->created_at));
                        })
                        ->editColumn('query', function ($data) {
                            return \Str::limit($data->query, 50);
                        })
                        ->editColumn('msg', function ($data) {
                            return \Str::limit($data->msg, 200);
                        })
                        ->addColumn('action', function ($user) {
                            $html = '';
                            $cooment = \App\SupportComment::where('support_id', $user->id)->where('user_id', '!=', \Auth::user()->id)->where('flag', 0)->get()->count();
                            if ($cooment > 0) {
                                $html = '<span class="badge badge-danger right">' . $cooment . '</span>';
                            }
                            return $html . ' <a href="' . asset('support/messageview/' . $user->id) . '" class="btn  btn-outline-primary" id="' . $user->id . '">View</a>';
                        })
                        ->rawColumns(['query', 'msg', 'action'])
                        ->make(true);
    }

    function getAdmindata() {
        $users = Support::select(['id', 'query', 'msg', 'flag', 'created_at'])->get();
        return Datatables::of($users)
                        ->editColumn('created_at', function ($data) {
                            return date('d-m-Y H:i', strtotime($data->created_at));
                        })
                        ->editColumn('query', function ($data) {
                            if ($data->flag == 0) {
                                return '<b>' . \Str::limit($data->query, 50) . '</b>';
                            }
                            return \Str::limit($data->query, 50);
                        })
                        ->editColumn('msg', function ($data) {
                            return \Str::limit($data->msg, 200);
                        })
                        ->addColumn('action', function ($user) {
                            $html = '';
                            $cooment = \App\SupportComment::where('support_id', $user->id)->where('user_id', '!=', \Auth::user()->id)->where('flag', 0)->get()->count();
                            if ($cooment > 0) {
                                $html = '<span class="badge badge-danger right">' . $cooment . '</span>';
                            }
                            return $html . ' <a href="' . asset('support/messageview/' . $user->id) . '" class="btn  btn-outline-primary" id="' . $user->id . '">View</a>';
                        })
                        ->rawColumns(['query', 'msg', 'action'])
                        ->make(true);
    }

    function postSendmessage() {
        Support::create(['user_id' => \Auth::user()->id, 'query' => request('query'), 'msg' => request('msg'),'flag'=>0]);
        return \Redirect::back();
    }

    function postSendcomment() {
        \App\SupportComment::create(['user_id' => \Auth::user()->id, 'support_id' => request('support_id'), 'comment' => request('msg'),'flag'=>0]);
        return \Redirect::back();
    }

}
