<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\View\View;
use Yajra\DataTables\DataTables;
use App\User;
use App\Bank;
use App\State;

class SubAdminManageController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    function getAddnew() {
        $data['page_header'] = 'User Management';
        $data['packages'] = \App\Product::whereNotIn('package_name', ['Package-1'])->get();
        $data['banks'] = Bank::all();
        return \View::make('admin.usermanage.addnew', $data);
    }

    public function genTpassword() {
        $password = "";
        for ($i = 0; $i < 6; $i++) {
            $password .= rand(1, 9);
        }
        return $password;
    }

    public function postCreateuser(Request $request) {

        $refferal = User::where('username', request('username'))->where('role', 3)->first();
        if ($refferal) {
            return \Redirect::back()->with('error', 'Username Already Exits...');
        }
        $refferal = User::where('email', request('email'))->where('role', 3)->first();
        if ($refferal) {
            return \Redirect::back()->with('error', 'Email Already Exits...');
        }
        $this->validate($request, [
            'username' => 'required|unique:users|alpha_dash',
            'name' => 'required',
            'email' => 'email|required|unique:users|',
            'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
            'password_confirmation' => 'min:6',
        ]);
        $useridd = \DB::transaction(function()use($request) {
                    $user = new User();
                    $user->name = $request->name;
                    $user->username = $request->username;
                    $user->email = $request->email;
                    $user->mobile = $request->mobile;
                    $user->role = 3;
                    $user->rights = request('rights') ? serialize(request('rights')) : null;
                    $user->password = bcrypt($request->password);
                    $user->password_text = $request->password;
                    $user->active = 1;
                    $user->save();
                    return 'ok';
                });
        return \Redirect::to('subadmin')->with('success', 'Created Successfully...');
    }

    function getIndex() {
        
        $data['page_header'] = 'User Management';
        $data['r_array'] = User::rightlist();
        
        
        return \View::make('admin.subadmin.index', $data);
    }

    function getData() {
        $array = User::rightlist();
        $users = User::where('role', 3);
        $users = $users->select(['users.id', 'username', 'name', 'rights', 'last_name', 'email', 'mobile', 'password_text', 'tpass', 'sponser_id', 'sponser', 'placed_under', 'position', 'users.created_at', 'users.active', 'suspend'])->get();
        return Datatables::of($users)
                        ->editColumn('rights', function($row)use($array) {
                            $rs = @unserialize($row->rights)?unserialize($row->rights):array();
                            $html = '';
                            foreach($rs as $r)
                            {
                                $html .= isset($array[$r])?$array[$r]:'';
                                $html .= '<br>';
                            }
                            return $html;
                        })
                        ->editColumn('invseted', function($row) {
                            return \App\WalletRequest::where('user_id', $row->id)->sum('amount');
                        })
                        ->editColumn('name', function($row) {
                            return $row->name . ' ' . $row->last_name;
                        })
                        ->editColumn('sponser', function($row) {
                            if ($row->getsponsorid) {
                                $html = $row->getsponsorid ? $row->getsponsorid->username : $row->sponser;
                                //$html2 = $row->getsponsorid->name . ' ' . $row->getsponsorid->last_name;

                                return $html;
                            }
                            return '';
                        })
                        ->editColumn('active', function($row) {
                            if ($row->active == 0) {
                                return '<span class="badge badge-danger">Inactive</span>';
                            }
                            return '<span class="badge badge-success">Active</span>';
                        })
                        ->editColumn('password_text', function($row) {
                            return $row->password_text . '<br>' . $row->tpass;
                        })
                        ->addColumn('action', function ($user) {
                            $html = '<a href="' . asset('subadmin/details/' . $user->id) . '" class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></a>';
                            $html .= '<a href="' . asset('usermanage/changeuserpassword?user_id=' . $user->id) . '" class="btn btn-sm btn-info"><i class="fas fa-key"></i></a>';
                            if ($user->suspend == 0) {
                                $html .= '<button class="btn btn-sm btn-danger setinactiveuser" id="' . $user->id . '">InActive</button>';
                            } else {
                                $html .= '<button class="btn btn-sm btn-success setreactiveinactiveuser" id="' . $user->id . '">Active</button>';
                            }
                            return $html;
                        })
                        ->editColumn('created_at', function($row) {
                            return date('d F Y', strtotime($row->created_at));
                        })
                        ->rawColumns(['action','rights', 'username', 'password_text', 'active', 'sponser', 'packages'])
                        ->make(true);
    }

    function postInactiveuser() {
        $user = User::find(request('row_id'));
        if ($user) {
            $user->update(['suspend' => 1]);
        }
    }

    function postReinactiveuser() {
        $user = User::find(request('row_id'));
        if ($user) {
            $user->update(['suspend' => 0]);
        }
    }

    function getProfile() {
        $data['page_header'] = 'User Profile';
        $user_id = \Auth::user()->id;
        $data['user'] = User::find($user_id);
        $data['banks'] = Bank::all();
        if ($data['user']) {
            return view('profile', $data);
        }
    }

    function getDetails($id) {
        $data['page_header'] = 'User Profile';
        $user_id = $id;
        $data['user'] = User::find($user_id);
        $data['r_array'] = User::rightlist();
        $data['banks'] = Bank::all();
        if ($data['user']) {
            return view('admin.subadmin.profile', $data);
        }
    }

    function postChangeposition(Request $request) {
        $user = User::find(\Auth::user()->id);
        if ($user) {
            $user->update(['set_position' => request('set_position')]);
        }
        return \Redirect::back();
    }

    function postChangeprofileimage(Request $request, $id) {
        $request->validate([
            'profile_image' => 'required|mimes:png,jpg,jpge',
        ]);

        $user = User::where('id', $id)->first();
        if ($user) {
            if ($request->hasFile('profile_image')) {

                $destinationPath = public_path() . '/profile_image/' . $user->profile_image;
                \File::delete($destinationPath);

                $file = $request->file('profile_image');
                $destinationPath = public_path() . '/profile_image/';
                $filename1 = \Str::random(10) . '.' . $file->getClientOriginalExtension();

                $file->move($destinationPath, $filename1);



                $user->update(['profile_image' => $filename1]);
            }
        }

        return \Redirect::back();
    }

    public function postUpdateuser($id, Request $request) {

        $this->validate($request, [
//            'username' => 'required|alpha_dash|unique:users,username,' . $id,
            'name' => 'required',
            //'email' => 'required|email|unique:users,email,' . $id,
            'mobile' => 'required|max:10|unique:users,mobile,' . $id,
        ]);
        $ok = \DB::transaction(function()use($request, $id) {
                    $detail = User::where('id', $id)->first();
                    if ($detail) {
//                        $detail->username = $request->username;
                        $detail->name = $request->name;
                        $detail->last_name = $request->last_name;
                        $detail->email = $request->email;
                        $detail->rights = request('rights') ? serialize(request('rights')) : null;
                        $detail->pan_no = $request->pan_no;
                        $detail->mobile = $request->mobile;
                        $detail->boold_group = $request->boold_group;
                        $detail->save();
                    }
                    return 1;
                });
        if ($ok == 1) {
            return \Redirect::back()->with('success', 'Admin Details Updated Successfully');
        }
        return \Redirect::back()->with('error', 'Request Could not be processed');
    }

    public function postUpdateuseraddress($id, Request $request) {

        $ok = \DB::transaction(function()use($request, $id) {
                    $detail = User::where('id', $id)->first();
                    if ($detail) {
//                        $detail->username = $request->username;
                        $detail->state = $request->state;
                        $detail->district = $request->district;
                        $detail->city = $request->city;
                        $detail->pin_code = $request->pin_code;
                        $detail->address = $request->address;
                        $detail->save();
                    }
                    return 1;
                });
        if ($ok == 1) {
            return \Redirect::back()->with('success', 'Address Details Updated Successfully');
        }
        return \Redirect::back()->with('error', 'Request Could not be processed');
    }

    public function postUpdatetoken($id, Request $request) {

        $this->validate($request, [
            'token' => 'required'
        ]);

        $ok = \DB::transaction(function()use($request, $id) {
                    $detail = User::where('id', $id)->first();
                    if ($detail) {
                        $detail->token = $request->token;
                        $detail->save();
                    }
                    return 1;
                });
        if ($ok == 1) {
            return \Redirect::back()->with('success', 'Wallet Address Updated Successfully');
        }
        return \Redirect::back()->with('error', 'Request Could not be processed');
    }

    public function getChangepassword(Request $request) {
        $data['page_header'] = 'Chane Password';
        $data['user'] = User::find(\Auth::user()->id);
        return view('changepass', $data);
    }

    public function getChangeuserpassword(Request $request) {
        $data['page_header'] = 'Chane Password';
        $data['user'] = User::find(request('user_id'));
        return view('admin.usermanage.changepass', $data);
    }

    public function postSavepass(Request $request) {
        $request->validate([
            'old_password' => 'required',
            'password' => 'required|min:5|confirmed',
            'password_confirmation' => 'required'
        ]);
        $user = \App\User::where('id', request('user_pass_id'))->first();
        if ($user) {
            if ($request->old_password != $user->password_text) {
                return \Redirect::back()->with('error', 'Your Old Password Not Matched.');
            }
            $password = $request->password;
            $user->password_text = $password;
            $user->password = bcrypt($password);
            $user->save();
            return \Redirect::back()->with('success', 'Your Login Password Changed. - ' . $password);
        } else {
            return \Redirect::back()->with('error', 'Something is wrong...');
        }
    }

    public function postSavetranpass(Request $request) {
        $request->validate([
            'old_password' => 'required',
            'password' => 'required|min:4|confirmed',
            'password_confirmation' => 'required'
        ]);
        $user = \App\User::where('id', request('user_pass_id'))->first();
        if ($user) {
            if ($request->old_password != $user->tpass) {
                return \Redirect::back()->with('error', 'Your Old Transaction Password Not Matched.');
            }
            $password = $request->password;
            $user->tpass = $password;
            $user->save();

            return \Redirect::back()->with('success', 'Your Transaction Password Changed. - ' . $password);
        } else {
            return \Redirect::back()->with('error', 'Something is wrong...');
        }
    }

    function getBankdata($user_id) {

        $users = \App\BankAccount::where('user_id', $user_id)
                        ->select(['id', 'user_id', 'number', 'holder_name', 'bank_name', 'branch_name', 'ifsc_code'])->get();
        return Datatables::of($users)
                        ->addColumn('action', function ($user) {
                            return '<a href="javascript:;" class="btn  btn-outline-primary update_btn" id="' . $user->id . '"><i class="fas fa-edit"></i></a>
                            <a href="javascript:;" class="btn btn-outline-danger delete_btn" id="' . $user->id . '"><i class="fas fa-trash-alt"></i></a>';
                        })
                        ->rawColumns(['question', 'ans', 'action'])
                        ->make(true);
    }

    function postSavebankdetails(Request $request, $user_id) {
        if (request('delete_row') == 'delete_row') {
            $find = \App\BankAccount::where('id', request('row_id'))->where('user_id', $user_id)->first();
            if ($find) {
                //$find->delete();
                $find->forceDelete();
            }
            return \Response::json(['code' => 'ok']);
        }
        if (request('edit_data') == 'edit_data') {
            $find = \App\BankAccount::where('id', request('row_id'))->where('user_id', $user_id)->first();
            if ($find) {
                return \Response::json(['row' => $find]);
            }
            return \Response::json(['code' => 'ok']);
        }
        if (request('update_id')) {
            $find = \App\BankAccount::where('id', request('update_id'))->where('user_id', $user_id)->first();
            if ($find) {
                $find->update([
                    'number' => $request->account_number ? $request->account_number : '',
                    'holder_name' => $request->payee_name ? $request->payee_name : '',
                    'branch_name' => $request->branch ? $request->branch : '',
                    'ifsc_code' => $request->ifsc ? $request->ifsc : '',
                    'bank_name' => $request->bank_name,
                ]);
                return \Redirect::back()->with('success', 'Bank Details Update Successfully');
            }
        }
        \App\BankAccount::create([
            'user_id' => $user_id,
            'number' => $request->account_number ? $request->account_number : '',
            'holder_name' => $request->payee_name ? $request->payee_name : '',
            'branch_name' => $request->branch ? $request->branch : '',
            'ifsc_code' => $request->ifsc ? $request->ifsc : '',
            'bank_name' => $request->bank_name,
        ]);
        return \Redirect::back()->with('success', 'Bank Details Added Successfully');
    }

}
