<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use App\User;
use App\Faqs;
use App\CommonSetting;
use Carbon\Carbon;
use Carbon\CarbonPeriod;

class ReportsController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    public function getMyteam() {
        $data['page_header'] = 'Tree';

        $user_id = request('usertree') ? request('usertree') : \Auth::user()->username;

        $user_id = \App\User::where('username', $user_id)->first();
        if ($user_id) {
            $user_id = $user_id->id;
        } else {
            $user_id = '0';
        }
        $data['page_header'] = 'Level Report';
        if ($user_id == 0) {
            $data['levels'] = array_filter([]);
        } else {
            $datalist = \App\User::getDepth(array($user_id), $array = array(), $count = 1);
            $data['levels'] = \App\User::array_flatten($datalist);
            $array = array_map('array_filter', $data['levels']);
            $data['levels'] = array_filter($array);
        }
        $data['user'] = \App\User::find($user_id);
        if (\Auth::user()->role == 1) {
            $data['levelend'] = 5000;
        } else {
            $data['levelend'] = 6;
        }
        return view('level_report', $data);
    }

    public function getMydirects() {
        $data['page_header'] = 'My Direct Affiliates';
        $data['userdetils'] = User::where('sponser_id', \Auth::user()->id)->orderBy('id', 'asc')->get();

        $data['user'] = User::find(\Auth::user()->id);
        return view('my_directs', $data);
    }

    public function getTeamtree() {

        if (request('usertree')) {
            $data['user'] = User::where('username', request('usertree'))->first();
            $data['user_inner'] = \App\Tree::where('username', request('usertree'))->first();
        } else {
            $data['user'] = User::find(\Auth::user()->id);
            $data['user_inner'] = \App\Tree::find(\Auth::user()->id);
        }
        return view('admin.usermanage.tree', $data);
    }

    public function getTripachievers() {
        $data['page_header'] = 'Trip Achievers';

        $data['user'] = User::find(\Auth::user()->id);

        $data['tripachievers'] = \App\AwardReward::all();

        return view('tripachievers', $data);
    }

    public function getReferralincomeall() {

        $data['page_header'] = 'Level Income Report';
        $data['users'] = User::where('role', 2)->get();
        return view('referral_roi_all', $data);
    }

    public function getReferralincome($id) {

        if (\Auth::user()->id != $id) {
            //exit;
        }

        $data['page_header'] = 'Level Income Report';
        $data['userdetils'] = \App\ReferralRoi::where('user_id', $id)->groupBy('referral_id')->groupBy('wallet_request_id')->orderBy('level')->get();
        $data['user'] = User::find($id);
        return view('referral_roi', $data);
    }

    public function getReferralincomedetails($id) {
        $data['page_header'] = 'My Referral Income';
        $find = \App\ReferralRoi::find($id);
        $data['reffer'] = $find;
        $data['userdetils'] = \App\ReferralRoi::where('user_id', $find->user_id)
                        ->where('user_id', $find->user_id)->where('referral_id', $find->referral_id)->where('level', $find->level)
                        ->where('wallet_request_id', $find->wallet_request_id)
                        ->where('status', 1)
                        ->select('id', 'user_id', 'referral_id', 'level', 'wallet_request_id', 'date', 'days', 'status', 'amount', 'charges', 'net_amount')->groupBy('date')->get();

        $data['user'] = User::find($find->user_id);

        return view('direct_income_details', $data);
    }

    public function getchangedatebooster() {
        $boosters = \App\User::whereIn('id', [41, 78, 6])->get();
        foreach ($boosters as $b) {
            $booster = \App\BoosterIncome::where('user_id', $b->id)->get();
            $date_approve = '2024-04-09';
            foreach ($booster as $roi) {
                $date_approve = date('Y-m-d', strtotime("+1 day", strtotime($date_approve)));
                if (date('l', strtotime($date_approve)) == "Sunday") {
                    $date_approve = date('Y-m-d', strtotime("+1 day", strtotime($date_approve)));
                }
                $roi->update(['date' => $date_approve]);
            }
        }
    }

    public function getRoiincome() {
        if (\Auth::user()->role == 2) {
            $data['page_header'] = 'My ROI Income';
            $data['packages'] = \App\WalletRequest::where('user_id', \Auth::user()->id)
                    ->whereIn('status', [1, 3])
                    ->select('id', 'package_id', 'user_id', 'package_name', 'created_at', 'transaction_id', 'payment_proof', 'wallet_address', 'status', 'reason', 'approve_date', 'add_type', 'monthly_income', 'referral_roi', 'package_roi', 'amount')
                    ->get();

            $data['user'] = User::find(\Auth::user()->id);
            return view('dailyroi_income_details', $data);
        }
        $data['page_header'] = 'My ROI Income';
        $data['users'] = User::where('role', 2)->get();
        $data['user'] = User::find(\Auth::user()->id);
        return view('dailyroi_income', $data);
    }

    public function getRoiincomedetails($id) {
        $data['page_header'] = 'My ROI Income';
        $data['packages'] = \App\WalletRequest::where('user_id', $id)
                        ->where('status', 1)
                        ->select('id', 'package_id', 'user_id', 'package_name', 'created_at', 'transaction_id', 'payment_proof', 'wallet_address', 'status', 'reason', 'approve_date', 'add_type', 'monthly_income', 'referral_roi', 'package_roi', 'amount')->get();
        $data['user'] = User::find($id);
        return view('dailyroi_income_details', $data);
    }

    public function getAwardreward() {
        $data['page_header'] = 'My ROI Income';
        $data['user'] = User::find(\Auth::user()->id);
        return view('awardreward', $data);
    }

    public function getDirectincome() {
        $data['page_header'] = 'My Direct Affiliates';
        if (\Auth::user()->role == 1) {
            $query = \App\DirectReferral::query();
            if (request('from_date')) {
                $query->whereDate('date', '>=', request('from_date'));
            }
            if (request('till_date')) {
                $query->whereDate('date', '<=', request('till_date'));
            }
            $data['userdetils'] = $query->get();
        } else {
            $data['userdetils'] = \App\DirectReferral::where('user_id', \Auth::user()->id)->get();
        }
        $data['user'] = User::find(\Auth::user()->id);

        return view('direct_income', $data);
    }

    public function getboosterincome() {
        $data['page_header'] = 'My Booster Income';
        $data['monthly'] = \App\BoosterIncome::where('user_id', \Auth::user()->id)->where('status', 1)->get();
        $data['abcheck'] = \App\BoosterIncome::where('user_id', \Auth::user()->id)->first();

        $data['user'] = User::find(\Auth::user()->id);
        return view('booster_income', $data);
    }

    public function getGoldmining() {
        $data['page_header'] = 'My Booster Income';
        $data['userdetils'] = \App\DirectReferral::where('user_id', \Auth::user()->id)->get();

        $data['one'] = User::where('sponser_id', \Auth::user()->id)->leftJoin('wallet_request', 'users.sponser_id', '=', 'wallet_request.user_id')->where('amount', 10000)->get()->count();
        $data['two'] = User::where('sponser_id', \Auth::user()->id)->leftJoin('wallet_request', 'users.sponser_id', '=', 'wallet_request.user_id')->where('amount', 50000)->get()->count();
        $data['three'] = User::where('sponser_id', \Auth::user()->id)->leftJoin('wallet_request', 'users.sponser_id', '=', 'wallet_request.user_id')->where('amount', 100000)->get()->count();
        $data['four'] = User::where('sponser_id', \Auth::user()->id)->leftJoin('wallet_request', 'users.sponser_id', '=', 'wallet_request.user_id')->where('amount', 500000)->get()->count();
        $data['five'] = User::where('sponser_id', \Auth::user()->id)->leftJoin('wallet_request', 'users.sponser_id', '=', 'wallet_request.user_id')->where('amount', 1000000)->get()->count();

        $data['user'] = User::find(\Auth::user()->id);
        return view('goldmining_income', $data);
    }

    public function getConsolidated() {
        if (\Auth::user()->role == 2) {
            $data['users'] = User::where('id', \Auth::user()->id)->get();
        } else {
            $userids = \App\Wallet::groupBy('user_id')->pluck('user_id');
            $data['users'] = User::whereIn('id', $userids)->where('role', 2)->get();
        }
        $start = Carbon::create(2025, 9, 1); // 01-09-2025
        $end = Carbon::today();              // today

        $data['dates'] = collect(CarbonPeriod::create($start, $end))->sortDesc();
        $data['directshow'] = 'yes';
        return view('admin.consolidated', $data);
    }

    public function getConsolidatedno() {
        if (\Auth::user()->role == 2) {
            $data['users'] = User::where('id', \Auth::user()->id)->get();
        } else {
            $data['users'] = User::where('role', 2)->get();
        }
        $start = Carbon::create(2025, 9, 1); // 01-09-2025
        $end = Carbon::today();              // today

        $data['dates'] = collect(CarbonPeriod::create($start, $end))->sortDesc();
        $data['directshow'] = 'no';
        return view('admin.consolidated', $data);
    }

    public function getWelcome() {

        $data['user'] = User::find(\Auth::user()->id);
        return view('welcome_letter', $data);
    }

    public function getIdcard() {

        $data['user'] = User::find(\Auth::user()->id);
        return view('id_card', $data);
    }

    public function getAlluserincome() {

        $data['user'] = User::find(\Auth::user()->id);
        return view('admin.alluserincome', $data);
    }

    public function getAlluserincomedata(Request $request) {
        $users = User::where('role', 2);
        return DataTables::of($users)
                        ->addIndexColumn()
                        ->addColumn('active', function ($row) use ($request) {
                            return $row->active == 1 ? 'Active' : 'InActive';
                        })
                        ->addColumn('created_at', function ($row) use ($request) {
                            return date('d/m/Y', strtotime($row->created_at));
                        })
                        ->addColumn('activation_date', function ($row) use ($request) {
                            $invested = \App\WalletRequest::where('user_id', $row->id)->where('status', 1)->orderBy('approve_date')->first();
                            return $invested ? date('d/m/Y', strtotime($invested->approve_date)) : '';
                        })
                        ->addColumn('invested', function ($row) use ($request) {
                            $invested = \App\WalletRequest::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            return \App\WalletRequest::amountFormat($invested);
                        })
                        ->addColumn('direct', function ($row) use ($request) {
                            return \App\DirectReferral::where('user_id', $row->id)
                                    ->where('status', 1)
                                    ->sum('amount');
                        })
                        ->addColumn('roi', function ($row) use ($request) {
                            return \App\RoiIncome::where('user_id', $row->id)
                                    ->where('status', 1)->sum('amount');
                        })
                        ->addColumn('levelroi', function ($row) use ($request) {
                            return \App\ReferralRoi::where('user_id', $row->id)->where('status', 1)->sum('amount');
                        })
                        ->addColumn('total', function ($row) {
                            $direct = \App\DirectReferral::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            $roi = \App\RoiIncome::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            $levelroi = \App\ReferralRoi::where('user_id', $row->id)->where('status', 1)->sum('amount');

                            $total = $direct + $roi + $levelroi;
                            return \App\WalletRequest::amountFormat($total);
                        })
                        ->addColumn('deductions', function ($row) {
                            $direct = \App\DirectReferral::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            $roi = \App\RoiIncome::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            $levelroi = \App\ReferralRoi::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            $total = $direct + $roi + $levelroi;
                            $deductions = $total * 10 / 100;
                            return \App\WalletRequest::amountFormat($deductions);
                        })
                        ->addColumn('net', function ($row) {
                            $direct = \App\DirectReferral::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            $roi = \App\RoiIncome::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            $levelroi = \App\ReferralRoi::where('user_id', $row->id)->where('status', 1)->sum('amount');
                            $total = $direct + $roi + $levelroi;
                            $deductions = $total * 10 / 100;
                            $net = $total - $deductions;
                            return \App\WalletRequest::amountFormat($net);
                        })
                        ->addColumn('paid', function ($row) use ($request) {
                            $paid = \App\Wallet::where('user_id', $row->id)->where('flag', 1)->sum('total_amount');
                            return \App\WalletRequest::amountFormat($paid);
                        })
                        ->addColumn('balance', function ($row) use ($request) {
                            $balance = \App\Wallet::getWalletblanceDate($row->id, request('from_date'), request('till_date'));
                            return \App\WalletRequest::amountFormat($balance);
                        })
                        ->make(true);
    }

    public function getAlluserincomedataexport(Request $request) {
        $dataarray = [];

        // ✅ Header row (exactly like your example)
        $dataarray[] = [
            'Member Id',
            'Member Name',
            'Phone Number',
            'Joining Date',
            'Activation Date',
            'Status',
            'Amount Invested',
            'Direct',
            'ROI',
            'Level ROI',
            'Total Income',
            'Total Deductions',
            'Net Amount',
            'Amount Paid',
            'Balance To Be Paid'
        ];

        // ✅ Data rows
        $users = User::where('role', 2)->get();

        foreach ($users as $row) {

            $invested_date = \App\WalletRequest::where('user_id', $row->id)->where('status', 1)->orderBy('approve_date')->first();
            $invested = \App\WalletRequest::where('user_id', $row->id)->where('status', 1)->sum('amount');

            $direct = \App\DirectReferral::where('user_id', $row->id)->where('status', 1)->sum('amount');
            $roi = \App\RoiIncome::where('user_id', $row->id)->where('status', 1)->sum('amount');
            $levelroi = \App\ReferralRoi::where('user_id', $row->id)->where('status', 1)->sum('amount');

            $total = $direct + $roi + $levelroi;
            $deductions = $total * 10 / 100;
            $net = $total - $deductions;

            $paid = \App\Wallet::where('user_id', $row->id)->where('flag', 1)->sum('total_amount');
            $balance = $net - $paid;

            $dataarray[] = [
                $row->username,
                $row->name,
                $row->mobile,
                date('d/m/Y', strtotime($row->created_at)),
                $invested_date ? date('d/m/Y', strtotime($invested_date->approve_date)) : '',
                $row->active == 1 ? 'Active' : 'InActive',
                \App\WalletRequest::amountFormat($invested),
                \App\WalletRequest::amountFormat($direct),
                \App\WalletRequest::amountFormat($roi),
                \App\WalletRequest::amountFormat($levelroi),
                \App\WalletRequest::amountFormat($total),
                \App\WalletRequest::amountFormat($deductions),
                \App\WalletRequest::amountFormat($net),
                \App\WalletRequest::amountFormat($paid),
                \App\WalletRequest::amountFormat($balance)
            ];
        }
        return (new \Illuminate\Database\Eloquent\Collection($dataarray))->downloadExcel('Report.xlsx');
    }

}
