<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use App\User;
use App\Faqs;
use App\CommonSetting;

class PagesManageController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    function getAnnouncement() {
        $data['find'] = CommonSetting::where('field_name', 'announcement')->first();
        $data['page_header'] = 'Announcement Text';
        return \View::make('pages.announcement', $data);
    }

    function postsaveannouncement() {
        $find = CommonSetting::where('field_name', 'announcement')->first();
        if ($find) {
            $find->update(['field_value' => request('field_value')]);
        } else {
            CommonSetting::create(['field_name' => 'announcement', 'field_value' => request('field_value')]);
        }
        return \Redirect::back();
    }

    function getTermcondition() {
        $data['find'] = CommonSetting::where('field_name', 'termcondition')->first();
        $data['page_header'] = 'Terms & Conditions';
        return \View::make('admin.termcondition', $data);
    }

    function postSavetermcondition() {
        $find = CommonSetting::where('field_name', 'termcondition')->first();
        if ($find) {
            $find->update(['field_value' => request('field_value')]);
        } else {
            CommonSetting::create(['field_name' => 'termcondition', 'field_value' => request('field_value')]);
        }
        return \Redirect::back();
    }

    function getPrivacypolicy() {
        $data['page_header'] = 'Privacy Policy';
        $data['find'] = CommonSetting::where('field_name', 'privacypolicy')->first();
        return \View::make('admin.privacypolicy', $data);
    }

    function postSaveprivacypolicy() {
        $find = CommonSetting::where('field_name', 'privacypolicy')->first();
        if ($find) {
            $find->update(['field_value' => request('field_value')]);
        } else {
            CommonSetting::create(['field_name' => 'privacypolicy', 'field_value' => request('field_value')]);
        }
        return \Redirect::back();
    }

    function getFaqs() {
        $data['page_header'] = 'Faqs';
        return \View::make('admin.faqs', $data);
    }

    function postSavefaqs() {
        if (request('delete_row') == 'delete_row') {
            $find = Faqs::find(request('row_id'));
            if ($find) {
                $find->delete();
            }
            return \Response::json(['row' => '']);
        }
        if (request('edit_data') == 'edit_data') {
            $find = Faqs::find(request('row_id'));
            return \Response::json(['row' => $find]);
        }
        if (request('update_id')) {
            $find = Faqs::find(request('update_id'));
            if ($find) {
                $find->update(['question' => request('question'), 'ans' => request('ans')]);
            }
            return \Redirect::back();
        }
        Faqs::create(['question' => request('question'), 'ans' => request('ans')]);
        return \Redirect::back();
    }

    function getFaqsdata() {
        $users = Faqs::select(['id', 'question', 'ans'])->get();
        return Datatables::of($users)
                        ->editColumn('ans', function ($data) {
                            return \Str::limit($data->ans, 50);
                        })
                        ->editColumn('ans', function ($data) {
                            return \Str::limit($data->ans, 200);
                        })
                        ->addColumn('action', function ($user) {
                            return '<a href="javascript:;" class="btn  btn-outline-primary update_btn" id="' . $user->id . '"><i class="fas fa-edit"></i></a>
                            <a href="javascript:;" class="btn btn-outline-danger delete_btn" id="' . $user->id . '"><i class="fas fa-trash-alt"></i></a>';
                        })
                        ->rawColumns(['question', 'ans', 'action'])
                        ->make(true);
    }

    function getSettings() {
        $data['user'] = User::where('id', 1)->first();
        return \View::make('settings', $data);
    }

    function postSavegoldprive() {
        $user = User::where('id', 1)->first();
        if ($user) {
            $user->update(['withdrawal_btn' => request('withdrawal_btn')]);
        }
        return \Redirect::back()->with('success', 'Saved Successfully...');
    }

}
