<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller {

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        $this->middleware('auth', ['except' => ['packagedetails', 'postFetchsponsor', 'getRegister']]);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    function getDay() {


        $dowMap = array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');
        $dow_numeric = date('w');
        return $dowMap[$dow_numeric];
    }

    public function getChangedata() {
        exit;
        \App\WalletRequest::where('package_roi', 1)->update(['package_roi' => 0]);
        \App\WalletRequest::where('referral_roi', 1)->update(['referral_roi' => 0]);
        exit;
        $array = ['MTN426752',
            'MTN823303',
            'MTN749435',
            'MTN440561',
            'MTN032924',
            'MTN617034',
            'MTN333405',
            'MTN528245',
            'MTN186224',
            'MTN092322',
            'MTN972175',
            'MTN360907',
            'MTN403680',
            'MTN656103',
            'MTN193854',
            'MTN443715',
            'MTN124023',
            'MTN362723',
            'MTN271671',
            'MTN721462',
            'MTN123661',
            'MTN259042',
            'MTN360907',
            'MTN403680'];

        $user = \App\User::whereIn('username', $array)->get();
        $package = \App\Product::find(11);
        foreach ($user as $change) {
            $wallerrequest = \App\WalletRequest::where('user_id', $change->id)->where('status', 1)->where('package_id', 1)->first();
            if ($wallerrequest) {
                $wallerrequest->update(['package_id' => $package->id, 'package_name' => $package->package_name,
                    'amount' => $package->mrp, 'roi_per' => 0, 'number_of_day' => 0]);
            }
        }
    }

    public function index() {

        //\Artisan::call('calculate:cron');
        /*
          $records = \App\WalletRequest::where('status', 1)->select('*', \DB::raw('count(*) as total'))
          ->groupBy('user_id')
          ->having('total', '>', 1)
          ->get();
          foreach ($records as $row) {
          $data = \App\WalletRequest::where('status', 1)->where('user_id', $row->user_id)->orderBy('approve_date')->get();
          $i = 1;
          foreach ($data as $d) {
          if ($row->total != $i) {
          \App\RoiIncome::where('user_id', $d->user_id)->where('wallet_request_id', $d->id)->where('status', 0)
          ->update(['status' => 4]);
          }
          $i++;
          }
          }
         * 
         */
        $pack = \App\WalletRequest::where('status', 1)->where('user_id', \Auth::user()->id)->pluck('package_id', 'package_id')->all();
        $data['my_currentinvestment'] = \App\Product::whereIn('id', $pack)->sum('mrp');

        $data['my_last_invest'] = \App\WalletRequest::where('status', 1)->where('user_id', \Auth::user()->id)->orderby('approve_date', 'desc')->first();

        $data['roi_income'] = \App\RoiIncome::where('user_id', \Auth::user()->id)->where('status', 1)->sum('amount');

        $data['today_roi_income'] = \App\RoiIncome::where('user_id', \Auth::user()->id)->where('date', date('Y-m-d'))->where('status', 1)->sum('amount');

        $data['refer_roi'] = \App\ReferralRoi::where('user_id', \Auth::user()->id)->where('status', 1)->sum('amount');
        $data['today_refer_roi'] = \App\ReferralRoi::where('user_id', \Auth::user()->id)->where('status', 1)->where('date', date('Y-m-d'))->sum('amount');

        $data['direct_income'] = \App\DirectReferral::where('user_id', \Auth::user()->id)->where('status', 1)->sum('amount');


        $data['direct_team'] = \App\User::where('sponser_id', \Auth::user()->id)->get()->count();

        $my_team = \App\User::getMyinnerlist([\Auth::user()->id]);
        $data['total_team'] = count($my_team);
        $data['total_active_team'] = \App\User::whereIn('id', $my_team)->where('role', 2)->where('active', 1)->get()->count();


        $roi_income_team = \App\RoiIncome::whereIn('user_id', $my_team)->where('status', 1)->sum('amount');
        $refer_roi_team = \App\ReferralRoi::whereIn('user_id', $my_team)->where('status', 1)->sum('amount');
        $booster_income = \App\DirectReferral::whereIn('user_id', $my_team)->where('status', 1)->sum('amount');
        $data['Team_Business'] = \App\WalletRequest::whereIn('user_id', $my_team)->where('status', 1)->sum('amount');

        $direct_team_list = \App\User::where('sponser_id', \Auth::user()->id)->pluck('id', 'id')->all();
        $roi_income_team = \App\RoiIncome::whereIn('user_id', $direct_team_list)->where('status', 1)->sum('amount');
        $refer_roi_team = \App\ReferralRoi::whereIn('user_id', $direct_team_list)->where('status', 1)->sum('amount');
        $data['Direct_Business'] = $roi_income_team + $refer_roi_team;

        $data['withdrwal'] = \App\CashWallet::where('user_id', \Auth::user()->id)->where('flag', 1)->sum('total_amount');
        if (\Auth::user()->role == 1 || \Auth::user()->role == 3) {
            $data['total_uses'] = \App\User::where('role', 2)->get()->count();
            $data['total_a_uses'] = \App\User::where('role', 2)->where('active', 1)->get()->count();
            $data['total_in_uses'] = \App\User::where('role', 2)->where('active', 0)->get()->count();
            $data['package_pending'] = \App\WalletRequest::where('status', 0)->get()->count();
            $data['payoutrequest'] = \App\CashRequest::where('status', 0)->get()->count();

            $user_inner = \App\User::getMyinnerlist([\Auth::user()->id]);
            $data['total_invest'] = \App\WalletRequest::where('status', 1)->sum('amount');
            
            $data['today_invest'] = \App\WalletRequest::where('status', 1)->whereDate('created_at', date('Y-m-d'))->sum('amount');

            return view('admin_home', $data);
        }
        return view('home', $data);
    }

    public function packagedetails(Request $request) {

        $package = \App\Product::where('id', $request->id)->first();
        if ($package) {

            $html = '<h5 style="margin-bottom: 0;">Price - ' . amountFormat($package->mrp) . '</h5>';
            if ($package->monthly_roi != 0) {
                $html .= 'Monthly ROI - ' . $package->monthly_roi . '% Number Of Month ' . $package->month_number . '<br>';
            }
            if ($package->daily_roi != 0) {
                $html .= 'Daily ROI - ' . $package->daily_roi . '% Number Of Day ' . $package->day_number . '<br>';
            }
            if ($package->daily_amount != 0) {
                $html .= 'Daily Return Amount - ' . amountFormat($package->daily_amount) . ' Number Of Day ' . $package->day_amount . '<br>';
            }
            if ($package->monthly_amount != 0) {
                $html .= 'Monthly Return Amount - ' . amountFormat($package->monthly_amount) . ' Number Of Month ' . $package->month_amount . '<br>';
            }
            if ($package->extra_info) {
                $html .= nl2br($package->extra_info);
            }

            return \Response::json([$html]);
        }
    }

    public function postFetchsponsor(Request $request) {
        $user = \App\User::where('username', $request->get('sponsor'))->first();
        if ($user) {
            $num = "<span style='color: green;font-size: 18px;'>Refer Name :<b> " . $user->name . ' ' . $user->last_name . "</b></span> ";
        } else {
            $num = "<span style='color: red;font-size: 18px;'><b>This Referral Id Not Valid.</b></span> ";
        }
        return $num;
    }

    public function postFetchsponsor2(Request $request) {
        $user = \App\User::where('username', $request->get('sponsor'))->first();
        if ($user) {
            $num = "<span style='color: green;font-size: 18px;'>Member Name :<b> " . $user->name . ' ' . $user->last_name . "</b></span> ";
        } else {
            $num = "<span style='color: red;font-size: 18px;'><b>This Member Id Not Valid.</b></span> ";
        }
        return $num;
    }

    function getRegister($id) {
        if (\Session::get('view_login') == 'ok') {
            $data['user'] = \App\User::where('username', $id)->first();
            \Session::forget('view_login');
            return view('auth.register_ok', $data);
        }
        return \Redirect::to('/');
    }

    function addVlance() {
        /* Direct Reffer 5% */
        \DB::transaction(function() {
            $all_users = \App\WalletRequest::where('referral_roi', 0)->where('status', 1)
                    ->select('package_id', 'id', 'package_name', 'user_id', 'approve_date', 'amount', 'created_at')
                    ->get();
            foreach ($all_users as $user) {
                if ($user->getUser) {
                    if ($user->getUser->suspend == 0) {
                        $totalproceunit = $user->amount;
                        $amount = $totalproceunit * 2.5 / 100;
                        \App\DirectReferral::create(['user_id' => $user->getUser->sponser_id,
                            'referral_id' => $user->user_id, 'wallet_request_id' => $user->id,
                            'package_name' => $user->package_name, 'date' => date('Y-m-d', strtotime($user->approve_date)), 'amount' => $amount]);

                        $user->update(['referral_roi' => 1]);
                    }
                }
            }

            $refer_roi = \App\DirectReferral::whereDate('date', '<=', date('Y-m-d'))->where('status', 0)->get();
            foreach ($refer_roi as $week) {
                if ($week->getUser) {
                    if ($week->getreferralid->suspend == 0) {
                        $name = $week->getreferralid ? $week->getreferralid->name : '';

                        $wallet = new \App\Wallet();
                        $wallet->user_id = $week->user_id;
                        $wallet->amount = $week->amount;
                        $wallet->total_amount = $week->amount;
                        $wallet->flag = 0;
                        $wallet->text = 'Referral Income For User ' . $name . ' Direct Reffer for - ' . $week->package_name . ' Amount Added';
                        $wallet->created_at = date('Y-m-d H:i:s', strtotime($week->date));
                        $wallet->updated_at = date('Y-m-d H:i:s', strtotime($week->date));
                        $wallet->save();

                        $week->update(['status' => 1]);
                    }
                }
            }
        });
        /* End Direct Reffer 5% */
    }

}
