<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class RegisterController extends Controller {
    /*
      |--------------------------------------------------------------------------
      | Register Controller
      |--------------------------------------------------------------------------
      |
      | This controller handles the registration of new users as well as their
      | validation and creation. By default this controller uses a trait to
      | provide this functionality without requiring any additional code.
      |
     */

use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
//        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data) {
        return Validator::make($data, [
                    'name' => ['required', 'string', 'max:255'],
                    'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                    'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    function getMainLastnode($check, $positionInput, $newposition = array()) {
        $arrayposition = [$positionInput];
        foreach ($check as $f) {
            $check2 = User::where('placed_under', $f->username)->whereIn('position', [$positionInput])->pluck('position', 'username')->all();
            if (count($check2) < 1) {
                foreach ($arrayposition as $position) {
                    if (!in_array($position, $check2)) {
                        $newposition ['position'] = $position;
                        $newposition ['placed_under'] = $f->username;
                    }
                }
            } else {
                $checkt = User::where('placed_under', $f->username)->where('position', $positionInput)->orderBy('position')->get();
                return $this->getMainLastnode($checkt, $positionInput);
            }
            if ($newposition) {
                break;
            }
        }
        return $newposition;
    }

    public function showRegistrationForm() {
        $data['packages'] = \App\Product::whereNotIn('package_name', ['Package-1'])->get();
        return view('auth.register', $data);
    }

    public function register(Request $request) {
        \Session::forget('goldenfx_captcha');
        if (request('email')) {
            $this->validate($request, [
//                'username' => 'required|unique:users|alpha_dash',
                'name' => 'required',
                //'pan_no' => 'required',
                'email' => 'email|required|',
                'mobile' => 'required|max:10|',
                'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
                'password_confirmation' => 'min:6',
                'sponser' => 'required|exists:users,username'
            ]);
        } else {
            $this->validate($request, [
//                'username' => 'required|unique:users|alpha_dash',
                'name' => 'required',
                //'pan_no' => 'required',
                'mobile' => 'required|max:10|',
                'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
                'password_confirmation' => 'min:6',
                'sponser' => 'required|exists:users,username'
            ]);
        }
        $mobile = User::where('mobile', request('mobile'))->first();
        if ($mobile) {
            //return \Redirect::back()->with('error', 'Mobile Number. Already Registered....');
        }
        if (request('email')) {
            $email = User::where('email', request('email'))->first();
            if ($email) {
                //return \Redirect::back()->with('error', 'E-Mail Already Registered....');
            }
        }
        $pan_no_capital = '';
        $useridd = \DB::transaction(function()use($request, $pan_no_capital) {
                    $refferal = User::where('username', request('sponser'))->first();

                    $user = new User();
//            $user->username = $request->username;
                    $user->name = $request->name;
                    $user->email = $request->email;
                    $user->country_code = $request->country_code;
                    $user->mobile = $request->mobile;
                    $user->pan_no = $request->pan_no;
                    $user->role = 2;
                    $user->placed_id = 0;
                    $user->position_number = 0;
                    $pass = $this->genTpassword();
                    $user->password_text = $pass;
                    $user->password = bcrypt($pass);
                    $user->tpass = $this->genTpassword();
                    $user->sponser = $refferal->username;
                    $user->sponser_id = $refferal->id;
                    $user->country = $request->country;
                    $user->state = $request->state;
                    $user->active = 0;
                    $user->save();

                    $member = User::find($user->id);
                    $recordnum = $member->id;
                    $recordid = str_pad($recordnum, 4, 0, STR_PAD_LEFT);
                    if ($refferal->username == 'superadmin') {
                        $useridd = 'MT' . $recordid;
                    } else {
                        $useridd = 'MT' . $recordid;
                    }
                    $useridd = $this->generateUniqueUsername();

                    $member->username = $useridd;
                    $member->save();

                    if ($request->bank_name && $request->account_number) {
                        \App\BankAccount::create(['user_id' => $user->id, 'number' => $request->account_number,
                            'holder_name' => $request->name, 'bank_name' => $request->bank_name,
                            'branch_name' => $request->branch_name, 'ifsc_code' => $request->ifsc_code]);
                    }

                    if ($user->email) {
                        try {
                            //\Mail::to($user->email)->send(new \App\Mail\WelcomeEmail($user));
                        } catch (Exception $ex) {
                            
                        }
                    }
                    return $useridd;
//                  $user->sendEmailVerificationNotification();
                });

        \Session::put('view_login', 'ok');
        return \Redirect::to('frontdata/register/' . $useridd);

        return \Redirect::to('frontdata/register/' . $useridd)->with('success', 'Account Created Successfully... Your UserID - ' . $useridd . ' Store Safe Place.');
    }

    public function genTpassword() {
        $password = "";
        for ($i = 0; $i < 6; $i++) {
            $password .= rand(1, 9);
        }
        return $password;
    }

    function generateUniqueUsername() {
        do {
            $username = 'MTN' . str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
        } while (User::where('username', $username)->exists());

        return $username;
    }

    protected function create(array $data) {

        return User::create([
                    'name' => $data['name'],
                    'email' => $data['email'],
                    'password' => Hash::make($data['password']),
        ]);
    }

}
