<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class FundWallet extends Model {

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $table = 'fund_wallet';
    protected $fillable = ['user_id', 'amount', 'charges', 'total_amount', 'flag', 'text', 'pay_date', 'pay_mode', 'pay_id', 'pay_info'];

    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

    static function getTotalFundWalletblance() {

        $wallet_plus = \App\FundWallet::where('flag', 0)->sum('total_amount');
        $wallet_minus = \App\FundWallet::where('flag', 1)->sum('total_amount');

        return $retun = round($wallet_plus, 2) - round($wallet_minus, 2);
    }

    static function getWalletblance($user_id) {
        $user = User::where('id', $user_id)->first();
        if ($user->active == 0) {
            return 0;
        }
        $wallet_plus = \App\FundWallet::where('user_id', $user_id)->where('flag', 0)->sum('total_amount');
        $wallet_minus = \App\FundWallet::where('user_id', $user_id)->where('flag', 1)->sum('total_amount');

        return $retun = round($wallet_plus, 2) - round($wallet_minus, 2);

        $hold_amount = \App\CashRequest::where('user_id', $user_id)->where('status', 0)->sum('amount');
        return $wallet_plus;
    }

    static function getTotalearnings($user_id) {
        $wallet_plus = \App\FundWallet::where('user_id', $user_id)->where('flag', 0)
                        ->selectRaw('sum(total_amount) as total_amount')->groupBy('user_id')->first();

        $walletplus = $wallet_plus ? $wallet_plus->total_amount : 0;

        return $walletplus;
    }

}
