<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;

class CashWalletCron extends Command {

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cashwallet:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Amount Transfer Active Wallet to cash Wallet';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle() {
        try {
            \DB::transaction(function() {
                $users = User::where('role', 2)->where('active', 1)->get();
                foreach ($users as $user) {
                    $amount = \App\Wallet::getWalletblance($user->id);
                    if ($amount > 0) {
                        $my_package = \App\WalletRequest::where('status', 1)->where('user_id', $user->id)->first();
                        if ($my_package) {
                            
                            $sc = $amount * 10 / 100;
                            $sc_carge = round($sc, 2);

                            $total_charge = $sc_carge;

                            $netpaymemt = $amount - $total_charge;

                            \App\Wallet::create(['user_id' => $user->id, 'amount' => $amount, 'total_amount' => $netpaymemt, 'flag' => 1,
                                'text' => 'Amount Transfer Cash Wallet']);

                            \App\Wallet::create(['user_id' => $user->id, 'amount' => $total_charge, 'total_amount' => $total_charge, 'flag' => 1,
                                'text' => 'Amount Transfer Cash Tds/Sc Charges']);

                            \App\CashWallet::create(['user_id' => $user->id, 'amount' => $amount, 'charges' => $total_charge, 'total_amount' => $netpaymemt, 'flag' => 0,
                                'text' => 'Amount Added From Active Wallet']);
                        }
                    }
                }
				\App\CheckCron::create(['text' => 'cash wallet Cron']);
            });
        } catch (Exception $ex) {
            
        }
        echo 'All Calculation Done...';
    }

}
