<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CheckCron extends Model {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'check_cron';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['text'];

    //protected $guarded = array();

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

    function getreferralid() {
        return $this->belongsTo('\App\User', 'referral_id');
    }

    function getPackage() {
        return $this->belongsTo('\App\Product', 'package_id');
    }

}
